import com.nttdocomo.ui.*;

public class GraphicsTest extends IApplication {
    public void start() {
        Display.setCurrent(new TestCanvas());
    }
}

class TestCanvas extends Canvas {
    private String mesg = "hello, world";
    private Font font;
    private int mesg_x;
    private int mesg_y;
    private int[] fillPoly_x, fillPoly_y, drawPoly_x, drawPoly_y;
    private int width, height;

    public TestCanvas() {
        setBackground(Graphics.getColorOfName(Graphics.BLUE));

        width = getWidth();
        height = getHeight();

        font = Font.getFont(Font.FACE_PROPORTIONAL |
                            Font.STYLE_BOLD | Font.SIZE_MEDIUM);
        mesg_x = (width - font.stringWidth(mesg)) / 2;
        mesg_y = height / 2;

        fillPoly_x = new int[] { width/4, width*3/4, width/4, width*3/4 };
        fillPoly_y = new int[] { height/4, height/4, height*3/4, height*3/4 };

        drawPoly_x = new int[] { width/2, width/4, width*3/4, width/2 };
        drawPoly_y = new int[] { height/4, height*3/4, height*3/4, height/4 };
    }

    public void paint(Graphics g) {
        g.clearRect(0, 0, width, height);

        /* rectangle */
        g.setColor(Graphics.getColorOfName(Graphics.AQUA));
        g.fillRect(width/8, width/8, width - width/8*2, height - height/8*2);
        g.setColor(Graphics.getColorOfName(Graphics.RED));
        g.drawRect(width/8, width/8, width - width/8*2 - 1, height - height/8*2 - 1);

        /* polygon */
        g.setColor(Graphics.getColorOfName(Graphics.FUCHSIA));
        g.fillPolygon(fillPoly_x, fillPoly_y, fillPoly_x.length);
        g.setColor(Graphics.getColorOfName(Graphics.GREEN));
        g.drawPolyline(drawPoly_x, drawPoly_y, drawPoly_x.length);

        /* text */
        g.setFont(font);
        g.setColor(Graphics.getColorOfName(Graphics.GREEN));
        g.drawString(mesg, mesg_x, mesg_y);
    }
}
