/*
 * $Id: Main.java,v 1.2 2002/05/19 13:56:27 ymakise Exp $
 */

/*
 * Copyright (c) 2002, MAKISE Yoshitaro
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above
 *    copyright notice, this list of conditions and the following
 *    disclaimer in the documentation and/or other materials provided
 *    with the distribution.
 *
 * 3. Neither the name of the iModoki nor the names of its
 *    contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 * FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE
 * COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
 * OF THE POSSIBILITY OF SUCH DAMAGE.
 */

package jp.sourceforge.imodoki.converter;

import java.io.File;
import java.net.URL;
import java.net.MalformedURLException;
import java.util.List;
import java.util.Arrays;
import java.util.Iterator;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.StringTokenizer;

/**
 * Ѵġᥤ
 */
public class Main {
    public static final String VERSION = "0.0.1";

    private static URL s_jamURL = null;
    private static ConverterOption s_converterOption;
    private static RuntimeCompileOption s_compileOption;

    public static void main(String[] args) {
        s_converterOption = new ConverterOption();
        s_converterOption.setOutputDir(new File("."));
        s_converterOption.setWorkDir(null);
        s_converterOption.setKeepWorkDir(false);

        s_compileOption = new RuntimeCompileOption();

        parseArgs(args);

        if (s_jamURL == null) {
            usage();
            System.exit(1);
        }

        if (s_converterOption.getWorkDir() == null) {
            s_converterOption.setWorkDir(
                new File(s_converterOption.getOutputDir(), "imodoki.workdir"));
        }

        Converter converter =
            new Converter(s_jamURL, s_converterOption, s_compileOption);
        boolean success = converter.convert();
        System.exit(success ? 0 : 1);
    }

    private static void parseArgs(String[] args_ary) {
        List args = Arrays.asList(args_ary);

        for (Iterator i = args.iterator(); i.hasNext(); ) {
            String arg = (String)i.next();
            if (arg.charAt(0) == '-') {
                if (arg.equals("-e")) {
                    String list = requireNextArg(i, arg);
                    addCompileOption(list, true);
                } else if (arg.equals("-d")) {
                    String list = requireNextArg(i, arg);
                    addCompileOption(list, false);
                } else if (arg.equals("-outputdir")) {
                    String outputDir = requireNextArg(i, arg);
                    s_converterOption.setOutputDir(new File(outputDir));
                } else if (arg.equals("-workdir")) {
                    String workDir = requireNextArg(i, arg);
                    s_converterOption.setWorkDir(new File(workDir));
                } else if (arg.equals("-keep-workdir")) {
                    s_converterOption.setKeepWorkDir(true);
                } else if (arg.equals("-version")) {
                    System.out.println("iModoki converter version " + VERSION);
                    System.exit(1);
                } else {
                    System.err.println("Unrecognized option: " + arg);
                    System.exit(1);
                }
            } else {
                if (s_jamURL != null) {
                    usage();
                    System.exit(1);
                }

                try {
                    s_jamURL = new URL(arg);
                } catch (MalformedURLException urle) {
                    try {
                        s_jamURL = new File(arg).toURL();
                    } catch (MalformedURLException urle2) {
                        // Τ
                        System.err.println(urle2);
                        System.exit(1);
                    }
                }
            }
        }
    }

    private static String requireNextArg(Iterator itr, String option) {
        if (!itr.hasNext()) {
            System.err.println("Missing argument: " + option);
            System.exit(1);
        }

        return (String)itr.next();
    }

    private static void addCompileOption(String list, boolean value) {
        StringTokenizer st = new StringTokenizer(list, ",");
        while (st.hasMoreTokens()) {
            String id = st.nextToken().trim();
            try {
                s_compileOption.getBoolean(id);
                s_compileOption.setValue(id, value);
            } catch (IllegalArgumentException iae) {
                System.err.println("Unrecognized runtime configuration option: " + id);
                System.exit(1);
            }
        }
    }

    public static void usage() {
        System.out.println("usage: imodokic [options...] {jamfile|jamurl}");
        System.out.println();
        System.out.println("options:");
        System.out.println("  -e <id...>    specify comma-separeted IDs of runtime configuration option to enable");
        System.out.println("  -d <id...>    specify comma-separeted IDs of runtime configuration option to disable");
        System.out.println("  -outputdir <dir>");
        System.out.println("                specify output directory (default: .)");
        System.out.println("  -workdir <dir>");
        System.out.println("                specify work directory (default: $outputdir/imodoki.workdir)");
        System.out.println("  -keep-workdir");
        System.out.println("                keep work directory and not execute ant");
        System.out.println("  -version      show version and exit");
//         System.out.println("  -targetprofile <profile>");
//         System.out.println("                specify target profile (default: MIDP)");
//         System.out.println("                one of these: MIDP, KDDIP1, KDDIP2, JPHONE");
//         System.out.println("  -jadtemplate <file>");
//         System.out.println("                specify templete of output .jad file");
        // Ȥϥץ󥻥å
        // ѥ륪ץ(ȡʳ) @file ηǻǤ
        // ۤ⡩

        System.out.println();
        System.out.println("runtime configuration options:");
        SortedSet keys = new TreeSet(s_compileOption.getOptionIDs());
        Iterator itr = keys.iterator();
        while (itr.hasNext()) {
            String id = (String)itr.next();
            boolean val;
            try {
                val = s_compileOption.getBoolean(id);
            } catch (IllegalArgumentException iae) {
                continue;
            }
            System.out.println("  " + id + " (default: " +
                               (val ? "enabled" : "disabled") + ")");
        }
    }
}
