@echo off

if exist "%HOME%\antrc_pre.bat" call "%HOME%\antrc_pre.bat"

if not "%OS%"=="Windows_NT" goto win9xStart
:winNTStart
@setlocal

rem %~dp0 is name of current script under NT
set DEFAULT_IMODOKI_HOME=%~dp0

rem : operator works similar to make : operator
set DEFAULT_IMODOKI_HOME=%DEFAULT_IMODOKI_HOME%\..

if "%IMODOKI_HOME%"=="" set IMODOKI_HOME=%DEFAULT_IMODOKI_HOME%
set DEFAULT_IMODOKI_HOME=

rem Need to check if we are using the 4NT shell...
if "%eval[2+2]" == "4" goto setup4NT

rem On NT/2K grab all arguments at once
set ANT_CMD_LINE_ARGS=%*
goto doneStart

:setup4NT
set ANT_CMD_LINE_ARGS=%$
goto doneStart

:win9xStart
rem Slurp the command line arguments.  This loop allows for an unlimited number of 
rem agruments (up to the command line limit, anyway).

set ANT_CMD_LINE_ARGS=

:setupArgs
if %1a==a goto doneStart
set ANT_CMD_LINE_ARGS=%ANT_CMD_LINE_ARGS% %1
shift
goto setupArgs

:doneStart
rem This label provides a place for the argument list loop to break out 
rem and for NT handling to skip to.

rem find IMODOKI_HOME
if not "%IMODOKI_HOME%"=="" goto checkJava

rem check for ant in Program Files on system drive
if not exist "%SystemDrive%\Program Files\imodoki" goto checkSystemDrive
set IMODOKI_HOME=%SystemDrive%\Program Files\imodoki
goto checkJava

:checkSystemDrive
rem check for ant in root directory of system drive
if not exist %SystemDrive%\imodoki\nul goto checkCDrive
set IMODOKI_HOME=%SystemDrive%\imodoki
goto checkJava

:checkCDrive
rem check for ant in C:\ant for Win9X users
if not exist C:\imodoki\nul goto noAntHome
set IMODOKI_HOME=C:\imodoki
goto checkJava

:noAntHome
echo IMODOKI_HOME is not set and ant could not be located. Please set IMODOKI_HOME.
goto end

:checkJava
set _JAVACMD=%JAVACMD%
set LOCALCLASSPATH=%CLASSPATH%
for %%i in ("%IMODOKI_HOME%\lib\*.jar") do call "%IMODOKI_HOME%\bin\lcp.bat" %%i

if "%JAVA_HOME%" == "" goto noJavaHome
if "%_JAVACMD%" == "" set _JAVACMD=%JAVA_HOME%\bin\java
if exist "%JAVA_HOME%\lib\tools.jar" call "%IMODOKI_HOME%\bin\lcp.bat" %JAVA_HOME%\lib\tools.jar
if exist "%JAVA_HOME%\lib\classes.zip" call "%IMODOKI_HOME%\bin\lcp.bat" %JAVA_HOME%\lib\classes.zip
call "%IMODOKI_HOME%\bin\lcp.bat" %IMODOKI_HOME%\converter\classes
goto checkJikes

:noJavaHome
if "%_JAVACMD%" == "" set _JAVACMD=java
echo.
echo Warning: JAVA_HOME environment variable is not set.
echo   If build fails because sun.* classes could not be found
echo   you will need to set the JAVA_HOME environment variable
echo   to the installation directory of java.
echo.

:checkJikes
if not "%JIKESPATH%" == "" goto runAntWithJikes

:runAnt
"%_JAVACMD%" -classpath "%LOCALCLASSPATH%" -Dant.home="%IMODOKI_HOME%" -Dimodoki.home="%IMODOKI_HOME%" %ANT_OPTS% jp.sourceforge.imodoki.converter.Main %ANT_CMD_LINE_ARGS%
goto end

:runAntWithJikes
"%_JAVACMD%" -classpath "%LOCALCLASSPATH%" -Dant.home="%IMODOKI_HOME%" -Dimodoki.home="%IMODOKI_HOME%" -Djikes.class.path="%JIKESPATH%" %ANT_OPTS% jp.sourceforge.imodoki.converter.Main %ANT_CMD_LINE_ARGS%

:end
set LOCALCLASSPATH=
set _JAVACMD=
set ANT_CMD_LINE_ARGS=

if not "%OS%"=="Windows_NT" goto mainEnd
:winNTend
@endlocal

:mainEnd
if exist "%HOME%\antrc_post.bat" call "%HOME%\antrc_post.bat"

