/*
 * $Id: ClassNameReplacer.java,v 1.2 2002/05/03 14:33:25 ymakise Exp $
 */

/*
 * Copyright (c) 2002, MAKISE Yoshitaro
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above
 *    copyright notice, this list of conditions and the following
 *    disclaimer in the documentation and/or other materials provided
 *    with the distribution.
 *
 * 3. Neither the name of the iModoki nor the names of its
 *    contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 * FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE
 * COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
 * OF THE POSSIBILITY OF SUCH DAMAGE.
 */

package jp.sourceforge.imodoki.ant;

import java.io.*;
import org.apache.bcel.classfile.ClassParser;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Constant;
import org.apache.bcel.classfile.ConstantClass;
import org.apache.bcel.classfile.ConstantNameAndType;
import org.apache.bcel.classfile.ConstantUtf8;
import org.apache.bcel.classfile.ConstantPool;
import org.apache.bcel.classfile.Utility;
import org.apache.bcel.generic.ConstantPoolGen;

/*
FIXME:
  ߤμϼȴǡ֤ʸ Constant_Class 
  Constant_NameAndType ʳϻȤƤʤǤ⿷
  Utf8 ȥ Ƥޤ֤ Utf8 ȥ꤬
  ĤäƤޤ

  UTF8 եɤ˻ȤƤ뤫Ĵ٤ΤϰճѤǡ
  饹եΤ٤ƤβǽΤõɬפ롣
   JVM ͤ򤸤äɤޤʤȤǤʤġJVM ͤ
  Ѥä餽ɿ路ʤФʤʤ

  ष̤ѥȥκʤɤϥ饹ե륵︺ġ
  餻٤Ȥפ
*/

/**
 * 饹եΥ饹̾񤭴롣
 */
public class ClassNameReplacer {
    private JavaClass m_class;
    private ConstantPool m_orgCpool;
    private ConstantPoolGen m_cpool;

    public ClassNameReplacer(String fileName) throws IOException {
        ClassParser parser = new ClassParser(fileName);
        m_class = parser.parse();
        m_orgCpool = m_class.getConstantPool();
        m_cpool = new ConstantPoolGen(m_orgCpool);
    }

    /**
     * 饹̾ oldName  newName ֤롣
     *
     * @param  oldName  Ѵ Fully Qualified 饹̾
     * @param  newName  Ѵ Fully Qualified 饹̾
     */
    public void replace(String oldName, String newName) {
        oldName = oldName.replace('.', '/');
        newName = newName.replace('.', '/');
        String oldType = "L" + oldName + ";";
        String newType = "L" + newName + ";";

        /* 󥹥ȥס oldName ޤ२ȥõ
           ConstantClass  ConstantNameAndType */
        for (int i = 1; i < m_cpool.getSize(); i++) {
            Constant elem = m_cpool.getConstant(i);
            if (elem instanceof ConstantClass) {
                String name = ((ConstantClass)elem).getBytes(m_orgCpool);
                if (name.equals(oldName)) {
                    /* ⤷ĤС  UTF8 ȥ
                       饹̾λȤ򤽤ؽ񤭴롣 */
                    int newidx = m_cpool.addUtf8(newName);
                    ((ConstantClass)elem).setNameIndex(newidx);
                }
            } else if (elem instanceof ConstantNameAndType) {
                String sig = ((ConstantNameAndType)elem).getSignature(m_orgCpool);
                if (sig.indexOf(oldType) != -1) {
                    /* ⤷ĤС  UTF8 ȥ
                       饹̾λȤ򤽤ؽ񤭴롣 */
                    String newSig = Utility.replace(sig, oldType, newType);
                    int newidx = m_cpool.addUtf8(newSig);
                    ((ConstantNameAndType)elem).setNameIndex(newidx);
                }
            }
        }
    }

    /**
     * ߽Ƥ륯饹ե˽񤭽Ф
     */
    public void dump(String fileName) throws IOException {
        m_class.setConstantPool(m_cpool.getFinalConstantPool());
        m_class.dump(fileName);
    }

    /** ƥ */
    public static void main(String[] args) throws IOException {
        ClassNameReplacer replacer = new ClassNameReplacer(args[0]);
        replacer.replace("java.lang.String", "foo.bar.String");
        replacer.dump(args[0] + ".out");
    }
}
