#/*
# *  Copyright 2007-2009 hkrn <hikarin@users.sourceforge.jp>
# *
# *  Licensed under the Apache License, Version 2.0 (the "License");
# *  you may not use this file except in compliance with the License.
# *  You may obtain a copy of the License at
# *
# *      http://www.apache.org/licenses/LICENSE-2.0
# *
# *  Unless required by applicable law or agreed to in writing, software
# *  distributed under the License is distributed on an "AS IS" BASIS,
# *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# *  See the License for the specific language governing permissions and
# *  limitations under the License.
# */
#
# $Id: Note.pm 1826 2009-04-08 15:23:25Z hikarin $
#

package Img0ch::Plugin::Module::Note;

use strict;

sub new {
    my ( $iClass, $iBBS, $key ) = @_;
    my $iKernel = $iBBS->get_kernel();
    my ( undef, undef, undef, $day, $month, $year ) = localtime($key);
    $year  += 1900;
    $month += 1;
    my $repos_note
        = $iBBS->get_repos_path( $year, $month, $day, $key, 'note' );
    my $repos_note_dir = $repos_note;
    $repos_note_dir =~ s{/note.\w+\z}{}xms;

    if ( !-d $repos_note_dir ) {
        defined $File::Path::VERSION or require File::Path;
        File::Path::mkpath($repos_note_dir)
            or $iKernel->throw_io_exception($repos_note_dir);
    }
    my $bbs    = $iBBS->get_name();
    my $iRepos = $iKernel->get_repos($repos_note);

    bless {
        __count     => $iRepos->get_int("I:P:M:N.${bbs}.${key}._"),
        __param_set => 0,
        __param     => {},
        _bbs        => $iBBS,
        _kernel     => $iKernel,
        _key        => $key,
        _repos      => $iRepos,
    }, $iClass;
}

sub load {
    my ($iNote) = @_;
    $iNote->{_repos}->load();
    return 1;
}

sub save {
    my ($iNote) = @_;
    my $iRepos = $iNote->{_repos};

    if ( $iNote->{__param_set} ) {
        my $param = $iNote->{__param};
        my ( $bbs, $key ) = ( $iNote->{_bbs}->bbs(), $iNote->{_key} );
        my $resno  = $param->{resno};
        my $prefix = "I:P:M:N.${bbs}.${key}.${resno}";
        my $count  = $iNote->{__count} + 1;
        my $mtime  = $iRepos->get_int("${prefix}.count") + 1;

        $iRepos->set( "${prefix}.applet",   $param->{applet} );
        $iRepos->set( "${prefix}.count",    $mtime );
        $iRepos->set( "${prefix}.ellapse",  $param->{ellapse} );
        $iRepos->set( "${prefix}.modified", $param->{modified} );
        $iRepos->set( "${prefix}.pass",     $param->{pass} );
        $iRepos->set( "${prefix}.type",     $param->{type} );
        $iRepos->set_binary( "${prefix}.animation",
            ${ $param->{animation} } );
        $iRepos->set( "I:P:M:N.${bbs}.${key}._", $count );
        $iNote->{__count}     = $count;
        $iNote->{__param_set} = 0;
    }
    $iRepos->save();
    return 1;
}

sub get {
    my ( $iNote, $resno ) = @_;
    my $iRepos = $iNote->{_repos};
    my ( $bbs, $key ) = ( $iNote->{_bbs}->bbs(), $iNote->{_key} );
    my $prefix = "I:P:M:N.${bbs}.${key}.${resno}";

    return {
        animation => $iRepos->get_binary("${prefix}.animation"),
        applet    => $iRepos->get("${prefix}.applet"),
        count     => ( $iRepos->get_int("${prefix}.count") || 1 ),
        ellapse   => $iRepos->get_int("${prefix}.ellapse"),
        modified  => $iRepos->get_int("${prefix}.modified"),
        pass      => $iRepos->get("${prefix}.pass"),
        type      => $iRepos->get("${prefix}.type")
    };
}

sub get_image {
    my ( $iNote, $resno ) = @_;
    require Img0ch::Upload;
    my $iUpload = Img0ch::Upload->new( $iNote->{_bbs}, $iNote->{_key} );
    my $ext     = $iUpload->get($resno)->[0];
    my $path    = $iUpload->path( $resno, $ext );

    if ( -r $path ) {
        my $iKernel = $iNote->{_kernel};
        my $fh      = $iKernel->get_read_file_handle($path);
        binmode $fh;
        my $binary = do { local $/ = undef; <$fh> };
        close $fh or $iKernel->throw_io_exception($path);
        return $binary;
    }
    return '';
}

sub get_image_base64 {
    my ( $iNote, $resno ) = @_;
    my $image = $iNote->get_image($resno);
    if ( defined $MIME::Base64::VERSION
        or eval 'require MIME::Base64; 1' )
    {
        $image = MIME::Base64::encode_base64($image);
    }
    else {
        defined $MIME::Base64::Perl::VERSION or require MIME::Base64::Perl;
        $image = MIME::Base64::Perl::encode_base64($image);
    }
    return $image;
}

sub set {
    my ( $iNote, $resno, $param ) = @_;
    my $iRepos = $iNote->{_repos};

    $iNote->{__param}->{resno}     = $resno;
    $iNote->{__param}->{animation} = $param->{animation};
    $iNote->{__param}->{applet}    = $param->{applet};
    $iNote->{__param}->{ellapse}   = $param->{ellapse};
    $iNote->{__param}->{modified}  = $param->{modified};
    $iNote->{__param}->{pass}      = $param->{pass};
    $iNote->{__param}->{type}      = $param->{type};
    $iNote->{__param_set}          = 1;
    return;
}

sub set_key {
    my ( $iNote, $key ) = @_;
    my $iBBS    = $iNote->{_bbs};
    my $iKernel = $iNote->{_kernel};
    my $bbs     = $iBBS->get_name();
    $iNote->{_key} = $key;

    my ( undef, undef, undef, $day, $month, $year ) = localtime($key);
    $year  += 1900;
    $month += 1;
    my $repos_note
        = $iBBS->get_repos_path( $year, $month, $day, $key, 'note' );
    my $repos_note_dir = $repos_note;
    $repos_note_dir =~ s{/note.\w+\z}{}xms;
    if ( !-d $repos_note_dir ) {
        defined $File::Path::VERSION or require File::Path;
        File::Path::mkpath($repos_note_dir)
            or $iKernel->throw_io_exception($repos_note_dir);
    }

    my $iRepos = $iKernel->get_repos($repos_note);
    $iNote->{__count} = $iRepos->get_int("I:P:M:N.${bbs}.${key}._");
    $iNote->{_repos}  = $iRepos;
    return;
}

sub count { $_[0]->{__count} }

sub remove {
    my ( $iNote, $resno ) = @_;
    my $iRepos = $iNote->{_repos};
    my ( $bbs, $key ) = ( $iNote->{_bbs}->bbs(), $iNote->{_key} );
    my $prefix = "I:P:M:N.${bbs}.${key}.${resno}";

    $iRepos->remove("${prefix}.animation");
    $iRepos->remove("${prefix}.applet");
    $iRepos->remove("${prefix}.count");
    $iRepos->remove("${prefix}.ellapse");
    $iRepos->remove("${prefix}.modified");
    $iRepos->remove("${prefix}.pass");
    $iRepos->remove("${prefix}.type");

    my $prefix_count = "I:P:M:N.${bbs}.${key}._";
    $iRepos->set( $prefix_count, $iRepos->get_int($prefix_count) - 1 );
    $iNote->{__count}--;
    return;
}

1;
__END__
