#/*
# *  Copyright 2007-2009 hkrn <hikarin@users.sourceforge.jp>
# *
# *  Licensed under the Apache License, Version 2.0 (the "License");
# *  you may not use this file except in compliance with the License.
# *  You may obtain a copy of the License at
# *
# *      http://www.apache.org/licenses/LICENSE-2.0
# *
# *  Unless required by applicable law or agreed to in writing, software
# *  distributed under the License is distributed on an "AS IS" BASIS,
# *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# *  See the License for the specific language governing permissions and
# *  limitations under the License.
# */
#
# $Id: Host.pm 1840 2009-06-17 14:03:48Z hikarin $
#

package Img0ch::Plugin::Filter::Host;

use strict;
use Img0ch::Filter::RemoteHost qw();

sub check {
    my ( $iApp, $plugin_id ) = @_;

    if ( !$iApp->cap()->can_pass_proxy_access() ) {
        my $iFRH = Img0ch::Filter::RemoteHost->new( $iApp->bbs() );
        $iFRH->load();
        if ( !$iFRH->write_ok( $iApp->get_device_id() ) ) {
            $iApp->set_error('POST_FROM_DENIED_HOST');
            return 0;
        }
        if ( !$iFRH->write_ok( $iApp->get_remote_host() ) ) {
            $iApp->set_error('POST_FROM_DENIED_HOST');
            return 0;
        }
        if ( $iApp->request()->get_header('user-agent')
            =~ /p2-user-hash:\s*(\w+)/ )
        {
            if ( !$iFRH->write_ok($1) ) {
                $iApp->set_error('POST_FROM_DENIED_HOST');
                return 0;
            }
        }
    }
    return 1;
}

1;
__END__
