#/*
# *  Copyright 2007-2009 hkrn <hikarin@users.sourceforge.jp>
# *
# *  Licensed under the Apache License, Version 2.0 (the "License");
# *  you may not use this file except in compliance with the License.
# *  You may obtain a copy of the License at
# *
# *      http://www.apache.org/licenses/LICENSE-2.0
# *
# *  Unless required by applicable law or agreed to in writing, software
# *  distributed under the License is distributed on an "AS IS" BASIS,
# *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# *  See the License for the specific language governing permissions and
# *  limitations under the License.
# */
#
# $Id: Request.pm 1826 2009-04-08 15:23:25Z hikarin $
#

package Img0ch::Request;

use strict;
use warnings;
use Carp qw(croak);

sub new {
    croak 'Img0ch::Request->new() must be implemented';
}

sub credit {
    'img0ch(CGI)/' . Img0ch::Maple->VERSION;
}

sub init {
    croak 'Img0ch::Request->init() must be implemented';
}

sub param {
    croak 'Img0ch::Request->param() must be implemented';
}

sub get_header {
    croak 'Img0ch::Request->get_header() must be implemented';
}

sub set_header {
    croak 'Img0ch::Request->set_header() must be implemented';
}

sub is_uploadable {
    croak 'Img0ch::Request->is_uploadable() must be implemented';
}

sub tempfile {
    croak 'Img0ch::Request->tempfile() must be implemented';
}

sub filename {
    croak 'Img0ch::Request->filename() must be implemented';
}

sub upload {
    croak 'Img0ch::Request->upload() must be implemented';
}

sub cookie {
    croak 'Img0ch::Request->cookie() must be implemented';
}

sub send_http_header {
    croak 'Img0ch::Request->send_http_header() must be implemented';
}

sub print {
    croak 'Img0ch::Request->print() must be implemented';
}

1;
__END__
