#/*
# *  Copyright 2007-2009 hkrn <hikarin@users.sourceforge.jp>
# *
# *  Licensed under the Apache License, Version 2.0 (the "License");
# *  you may not use this file except in compliance with the License.
# *  You may obtain a copy of the License at
# *
# *      http://www.apache.org/licenses/LICENSE-2.0
# *
# *  Unless required by applicable law or agreed to in writing, software
# *  distributed under the License is distributed on an "AS IS" BASIS,
# *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# *  See the License for the specific language governing permissions and
# *  limitations under the License.
# */
#
# $Id: ClamAV.pm 1826 2009-04-08 15:23:25Z hikarin $
#

package Img0ch::Plugin::Upload::ClamAV;

use strict;
use ClamAV::Client qw();

sub check {
    my ($iApp)  = @_;
    my $iKernel = $iApp->kernel();
    my $iConfig = $iKernel->get_config();

    my $ud_socket = $iConfig->get('clamav.socket_name');
    my @args
        = $ud_socket
        ? ( socket_name => $ud_socket )
        : (
        socket_host => $iConfig->get('clamav.tcp_host'),
        socket_port => $iConfig->get_int('clamav.tcp_port')
        );
    my $clamav = ClamAV::Client->new(@args);
    $clamav->ping()
        or $iKernel->throw_exception('ClamAV DAEMON NOT ACTIVATE');

    my ( undef, $result )
        = $clamav->scan_path( $iApp->request()->tempfile() );
    if ($result) {
        $iApp->set_error('UPLOAD_INFECTED_FILE');
        $iApp->set_error_argument( { VIRUS => $result } );
        return 0;
    }

    return 1;
}

1;
__END__
