#/*
# *  Copyright 2007-2009 hkrn <hikarin@users.sourceforge.jp>
# *
# *  Licensed under the Apache License, Version 2.0 (the "License");
# *  you may not use this file except in compliance with the License.
# *  You may obtain a copy of the License at
# *
# *      http://www.apache.org/licenses/LICENSE-2.0
# *
# *  Unless required by applicable law or agreed to in writing, software
# *  distributed under the License is distributed on an "AS IS" BASIS,
# *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# *  See the License for the specific language governing permissions and
# *  limitations under the License.
# */
#
# $Id: JPOnly.pm 1826 2009-04-08 15:23:25Z hikarin $
#

package Img0ch::Plugin::Filter::JPOnly;

use strict;
use Img0ch::Plugin::Module::RACC qw();

sub check {
    my ($iApp)  = @_;
    my $iCap    = $iApp->cap();
    my $iConfig = $iApp->config();
    my $host    = $iApp->get_remote_host();

    if ( !$iCap->can_pass_proxy_access() and $host !~ /\.jp\z/xms ) {
        my $ip = $iApp->get_ip();
        if ( !Img0ch::Plugin::Module::RACC->is( $ip, 'JP', $iConfig ) ) {
            my $ok   = 0;
            my $path = $iConfig->get('SystemPath') . '/HOST-jp.ini';
            my $jp   = Img0ch::Config->new();
            $jp->load($path);
            for my $regex ( keys %{ $jp->get('regex.*') } ) {
                my $re = qr/$regex/xms;
                if ( $host =~ /$re/xms ) {
                    $ok = 1;
                    last;
                }
            }
            if ( !$ok ) {
                $iApp->set_error('POST_FROM_NOT_JP_HOST');
                return 0;
            }
        }
    }

    return 1;
}

1;
__END__
