#/*
# *  Copyright 2007-2009 hkrn <hikarin@users.sourceforge.jp>
# *
# *  Licensed under the Apache License, Version 2.0 (the "License");
# *  you may not use this file except in compliance with the License.
# *  You may obtain a copy of the License at
# *
# *      http://www.apache.org/licenses/LICENSE-2.0
# *
# *  Unless required by applicable law or agreed to in writing, software
# *  distributed under the License is distributed on an "AS IS" BASIS,
# *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# *  See the License for the specific language governing permissions and
# *  limitations under the License.
# */
#
# $Id: Config.pm 1826 2009-04-08 15:23:25Z hikarin $
#

package Img0ch::Plugin::BBS::Reaper::Config;

use strict;
use File::Basename qw();
use XML::TreePP qw();

sub register_hook {
    return {
        privilege => \&privilege,
        render    => \&render,
    };
}

sub privilege {
    my ( $zPlugin, $zUser, $plugin_id, $iBBS, $key ) = @_;
    $zUser->can_create_pool() or return 0;
    return 1;
}

sub render {
    my ( $zPlugin, $plugin_id, $iBBS, $key ) = @_;
    my $file = File::Basename::dirname(__FILE__) . '/layout.xml';
    my $tree = XML::TreePP->new();
    $zPlugin->parse_from_hash( $tree->parsefile($file) );
    return 1;
}

1;
__END__
