#/*
# *  Copyright 2007-2008 hkrn <hikarin@users.sourceforge.jp>
# *
# *  Licensed under the Apache License, Version 2.0 (the "License");
# *  you may not use this file except in compliance with the License.
# *  You may obtain a copy of the License at
# *
# *      http://www.apache.org/licenses/LICENSE-2.0
# *
# *  Unless required by applicable law or agreed to in writing, software
# *  distributed under the License is distributed on an "AS IS" BASIS,
# *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# *  See the License for the specific language governing permissions and
# *  limitations under the License.
# */
#
# $Id: VT.pm 1661 2008-03-09 23:53:39Z hikarin $
#

package Img0ch::Plugin::BBS::VT;

use strict;
use Img0ch::Thread::Virtual qw();

sub init {
    my ($iApp) = @_;
    my $iThread = $iApp->thread();

    if ( $iThread and $iThread->count() ) {
        my ( $iBBS, $key ) = ( $iApp->bbs(), $iThread->get_key() );
        my $iSetting = $iApp->setting();
        my $iTVirtual = Img0ch::Thread::Virtual->new( $iBBS, $key );

        map {
            $iSetting->set( $_,
                ( $iTVirtual->get_setting_int($_) || $iSetting->get_int($_) )
                )
        } $iTVirtual->get_setting_integer_keys();
        map {
            $iSetting->set( $_,
                ( $iTVirtual->get_setting($_) || $iSetting->get($_) ) )
            } (
            $iTVirtual->get_setting_string_keys(),
            $iTVirtual->get_setting_hidden_string_keys(),
            $iTVirtual->get_setting_boolean_keys(),
            );
    }

    return 1;
}

sub filter {
    my ( $iApp, $plugin_id ) = @_;
    my $iThread = $iApp->thread();

    if ( $iThread->count() ) {
        my ( $iBBS, $key ) = ( $iApp->bbs(), $iThread->get_key() );
        my $iCap = $iApp->cap();
        my $iTVirtual = Img0ch::Thread::Virtual->new( $iBBS, $key );
        if (   !$iCap->can_pass_proxy_access()
            and $iTVirtual->is_denied_remote_host( $iApp->get_remote_host() )
            )
        {
            $iApp->set_error('DENY_FROM_VT_LISTED_HOST');
            return 0;
        }
        if (   !$iCap->can_pass_proxy_access()
            and $iTVirtual->scan_text( $iApp->get_comment() ) )
        {
            $iApp->set_error('POST_WITH_NGWORD_IN_VT');
            return 0;
        }
        my $pos = $iTVirtual->get_setting('THREAD_POSITION');
        $pos and $iApp->set_thread_position($pos);
    }
    else {
        my $user = $iApp->get_annotation('VT:USER');
        my $pass = $iApp->get_annotation('VT:PASS');
        my $force
            = shift @{ $iApp->get_plugin_config( $plugin_id, 'force', 1 ) }
            || 0;
        if ( ( !$user or !$pass ) and $force ) {
            $iApp->set_error('NO_VIRTUAL_THREAD_ID');
            return 0;
        }
    }

    return 1;
}

sub create {
    my ($iApp) = @_;

    if ( $iApp->is_thread_builder() ) {
        my $user = $iApp->get_annotation('VT:USER');
        my $pass = $iApp->get_annotation('VT:PASS');
        if ( $user and $pass ) {
            my ( $iBBS, $key ) = ( $iApp->bbs(), $iApp->thread()->get_key() );
            my $iSetting = $iApp->setting();
            my $iTVirtual = Img0ch::Thread::Virtual->new( $iBBS, $key );

            $iTVirtual->set_user( $user, $pass, $iTVirtual->administrator() );
            if ( my $inherit = $iApp->get_annotation('VT:INHERIT') ) {
                $iTVirtual->inherit_from($inherit);
            }
            $iTVirtual->set_ngwords( $iApp->get_annotation('VT:NGWORD') );

            for my $setting_key ( $iTVirtual->get_setting_integer_keys() ) {
                my $value = Img0ch::Kernel::intval(
                    $iApp->get_annotation("VT:${setting_key}") );
                my $default = $iSetting->get_int($setting_key);
                $value > $default and $value = $default;
                $iTVirtual->set_setting( $setting_key,
                    $value || $iTVirtual->get_setting_int($setting_key) );
            }

            my $max_length = $iTVirtual->get_setting_string_max_length();
            for my $setting_key ( $iTVirtual->get_setting_string_keys() ) {
                my $value = $iApp->get_annotation("VT:${setting_key}");
                my $len   = length $value;
                $iTVirtual->set_setting( $setting_key,
                    ( $len and $len <= $max_length )
                    ? $value
                    : $iTVirtual->get_setting($setting_key) );
            }

            for my $setting_key ( $iTVirtual->get_setting_boolean_keys() ) {
                my $value = $iApp->get_annotation("VT:${setting_key}");
                $iTVirtual->set_setting( $setting_key, $value );
            }

            $iTVirtual->save();
        }
    }

    return 1;
}

1;
__END__
