#/*
# *  Copyright 2007-2008 hkrn <hikarin@users.sourceforge.jp>
# *
# *  Licensed under the Apache License, Version 2.0 (the "License");
# *  you may not use this file except in compliance with the License.
# *  You may obtain a copy of the License at
# *
# *      http://www.apache.org/licenses/LICENSE-2.0
# *
# *  Unless required by applicable law or agreed to in writing, software
# *  distributed under the License is distributed on an "AS IS" BASIS,
# *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# *  See the License for the specific language governing permissions and
# *  limitations under the License.
# */
#
# $Id$
#

package Img0ch::Filter::NGWord2;

use strict;

sub new {
    my ( $iClass, $iBBS ) = @_;
    my $iKernel = $iBBS->get_kernel();

    bless {
        _bbs => ( $iBBS->get_name() || 'test' ),
        _encoding => $iBBS->get_encoding(),
        _kernel   => $iKernel,
        _rs   => $iKernel->get_repos( $iKernel->get_repos_path('ngword') ),
        _utf8 => $iBBS->is_utf8(),
    }, $iClass;
}

sub load { $_[0]->{_rs}->load(); return 1 }

sub write_ok {
    my ( $iFNGW, $input ) = @_;
    my $iRepos       = $iFNGW->{_rs};
    my $bbs          = $iFNGW->{_bbs};
    my $prefix_top   = 'I:F:N';
    my $prefix_regex = qr/\AI:F:N\.$bbs\.(.+?)\./xms;
    my $id_table     = {};

    $iRepos->iterate(
        sub {
            my ( $key, $value, $bbs, $id_table, $prefix_regex ) = @_;
            if ( $key =~ /$prefix_regex/ ) {
                $id_table->{"${bbs}.$1"}
                    = $iRepos->get_int("I:F:N.${bbs}.$1.apply");
            }
            elsif ( $key =~ /\AI:F:N\.test\.(.+?)\./xms ) {
                $id_table->{"test.$1"}
                    = $iRepos->get_int("I:F:N.test.$1.apply");
            }
            return 0;
        },
        $bbs,
        $id_table,
        $prefix_regex
    );

    my $iKernel  = $iFNGW->{_kernel};
    my $bbs_utf8 = $iFNGW->{_utf8};
    my $encoding = $iFNGW->{_encoding};
    my $k2a      = {
        'name'    => 2,
        'mail'    => 4,
        'comment' => 8,
        'subject' => 16,
    };

    while ( my ( $id, $apply ) = each %{$id_table} ) {
        my $prefix = "${prefix_top}.${id}";
        my $flag   = $iRepos->get_int("${prefix}.flag") || next;
        my $entry  = $iRepos->get_binary("${prefix}.entry");
        my $utf8   = $iRepos->get("${prefix}.utf8");
        if ( $utf8 and !$bbs_utf8 ) {
            $entry = $iKernel->get_encoded_str( $entry, $encoding, 'utf8' );
        }
        while ( my ( $key, $text ) = each %$input ) {
            $text or next;
            $apply & 1 or $apply & ( $k2a->{$key} || 0 ) or next;
            if ( index( $text, $entry ) >= 0 ) {
                if ( $flag & 4 ) {
                    my $to = $iRepos->get_binary("${prefix}.replace");
                    if ( $utf8 and $bbs_utf8 ) {
                        $to = $iKernel->get_encoded_str( $to, $encoding,
                            'utf8' );
                    }
                    $text =~ s/\Q$entry\E/$to/gxms;
                    $input->{$key} = $text;
                    next;
                }
                elsif ( $flag & 2 ) {
                    $text =~ s/\Q$entry\E//gxms;
                    $input->{$key} = $text;
                    next;
                }
                else {
                    return 0;
                }
            }
        }
    }

    return 1;
}

1;
__END__
