#/*
# *  Copyright 2007 hkrn <hikarin@users.sourceforge.jp>
# *
# *  Licensed under the Apache License, Version 2.0 (the "License");
# *  you may not use this file except in compliance with the License.
# *  You may obtain a copy of the License at
# *
# *      http://www.apache.org/licenses/LICENSE-2.0
# *
# *  Unless required by applicable law or agreed to in writing, software
# *  distributed under the License is distributed on an "AS IS" BASIS,
# *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# *  See the License for the specific language governing permissions and
# *  limitations under the License.
# */
#
# $Id: banner.pm 970 2007-08-21 14:52:15Z hikarin $
#

package Zeromin2::App::banner;

use strict;
use Zeromin::Metadata qw();

sub load_main { _load( 'main_banner', @_ ) }

sub load_sub { _load( 'sub_banner', @_ ) }

sub load_mobile { _load( 'mobile_banner', @_ ) }

sub save_main { _save( 'main_banner', @_ ) }

sub save_sub { _save( 'sub_banner', @_ ) }

sub save_mobile { _save( 'mobile_banner', @_ ) }

sub _load {
    my ( $method, $zApp ) = @_;
    $zApp->privilege('can_edit_banner') or return $zApp->return_value(1);

    my $zMeta = Zeromin::Metadata->new( $zApp->kernel() );
    my $zBBS  = $zApp->bbs();
    my $data  = { IsTypeTemplate => 0 };
    $method .= '_utf8';

    if ($zBBS) {
        require Zeromin::Setting;
        my $zSetting = Zeromin::Setting->new($zBBS);
        %$data = (
            BBS_SUBTITLE   => $zSetting->get_utf8('BBS_SUBTITLE'),
            BBS_TYPE_THEME => $zSetting->get('BBS_TYPE_THEME'),
            IsTypeTemplate =>
                ( $zSetting->get('BBS_TEMPLATE') =~ /\Atype/xms ? 1 : 0 )
        );
    }

    my $content = $zMeta->$method;
    $content =~ s/\s+\n\s+/\n/gxms;
    $content =~ s/\A\s+//xms;
    $content =~ s/\s+\z//xms;
    $content =~ s/\n+\z//xms;
    $zApp->add_template_param(
        {   %$data,
            BBS => ( $zBBS ? $zBBS->get_id() : 0 ),
            Data => $content
        }
    );
    return $zApp->return_value(0);
}

sub _save {
    my ( $method, $zApp ) = @_;
    $zApp->check_csrf()                 or return $zApp->return_value(1);
    $zApp->privilege('can_edit_banner') or return $zApp->return_value(1);

    my $zMeta = Zeromin::Metadata->new( $zApp->kernel() );
    $zMeta->$method(
        \$zApp->kernel()->get_encoded_str(
            $zApp->request()->param( 'content', 1 ),
            undef, 'utf8'
        )
    );

    $method =~ s/_banner\z//xms;
    $zApp->logger( 1, 'MODIFIED BANNER: %s', [$method] );
    return $zApp->return_value(0);
}

1;
__END__
