#/*
# *  Copyright 2007-2008 hkrn <hikarin@users.sourceforge.jp>
# *
# *  Licensed under the Apache License, Version 2.0 (the "License");
# *  you may not use this file except in compliance with the License.
# *  You may obtain a copy of the License at
# *
# *      http://www.apache.org/licenses/LICENSE-2.0
# *
# *  Unless required by applicable law or agreed to in writing, software
# *  distributed under the License is distributed on an "AS IS" BASIS,
# *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# *  See the License for the specific language governing permissions and
# *  limitations under the License.
# */
#
# $Id: DNSBL.pm 1645 2008-02-06 15:40:18Z hikarin $
#

package Img0ch::Plugin::Module::DNSBL;

use strict;

my $available_dnsbl = {
    'bbq'        => 'niku.2ch.net',
    'bbx'        => 'bbx.2ch.net',
    'dsbl'       => 'list.dsbl.org',
    'rbl'        => 'all.rbl.jp',
    'spamcop'    => 'bl.spamcop.net',
    'spamhaus'   => 'zen.spamhaus.org',
    'empty'      => 'bsb.empty.us',
    'spamlookup' => 'bsb.spamlookup.net',
};

sub get_all_dnsbl {
    return [ keys %$available_dnsbl ];
}

sub get_hostname {
    my ( $iClass, $dnsbl_name ) = @_;
    return $available_dnsbl->{$dnsbl_name} || '';
}

sub add_dnsbl {
    my ( $iClass, $dnsbl_name, $dnsbl_hostname ) = @_;
    $available_dnsbl->{$dnsbl_name} = $dnsbl_hostname;
    return;
}

sub is_in_dnsbl {
    my ( $iClass, $dnsbl_name, $ip_int, $ip ) = @_;
    my $dnsbl_hostname = $available_dnsbl->{$dnsbl_name} || return 0;
    $dnsbl_hostname = '%d.%d.%d.%d.' . $dnsbl_hostname;

    my @rev_ip
        = $ip
        ? ( reverse split '\.', $ip )
        : ( reverse unpack 'C*', $ip_int );
    my @rs = gethostbyname( sprintf $dnsbl_hostname, @rev_ip );
    my $addr = $rs[4] || return 0;
    my @ip = unpack 'C*', $addr;

    return ( $ip[0] == 127 and $ip[1] == 0 and $ip[2] == 0 ) ? 1 : 0;
}

1;
__END__
