#/*
# *  Copyright 2007-2008 hkrn <hikarin@users.sourceforge.jp>
# *
# *  Licensed under the Apache License, Version 2.0 (the "License");
# *  you may not use this file except in compliance with the License.
# *  You may obtain a copy of the License at
# *
# *      http://www.apache.org/licenses/LICENSE-2.0
# *
# *  Unless required by applicable law or agreed to in writing, software
# *  distributed under the License is distributed on an "AS IS" BASIS,
# *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# *  See the License for the specific language governing permissions and
# *  limitations under the License.
# */
#
# $Id: UTF8Dat.pm 1645 2008-02-06 15:40:18Z hikarin $
#

package Img0ch::Plugin::BBS::UTF8Dat;

use strict;

my $utf8bom = pack 'C*', ( 0xef, 0xbb, 0xbf );

sub sync {
    my ($iApp) = @_;
    my $from = $iApp->thread()->path();
    -r $from or return 1;

    my $iKernel  = $iApp->kernel();
    my $compress = $iApp->setting()->get('BBS_COMPRESS_DAT');
    _sync( $iKernel, $from, $compress );
    return 1;
}

sub remove {
    my ( $iBBS, $plugin_id, $key ) = @_;
    _remove( $iBBS->get_kernel(), $iBBS->get_thread_instance($key)->path() );
    return 1;
}

sub repair {
    my ( $iBBS, $plugin_id, $info ) = @_;
    my $iKernel = $iBBS->get_kernel();
    my $iThread = $iBBS->get_thread_instance(0);

    for my $key ( @{ $iBBS->get_subject_instance()->to_array() } ) {
        $iThread->set_key($key);
        _sync( $iKernel, $iThread->path(), 0 );
    }
    for my $key ( @{ $info->{removed} } ) {
        $iThread->set_key($key);
        _remove( $iKernel, $iThread->path() );
    }

    return 1;
}

sub _sync {
    my ( $iKernel, $from, $compress ) = @_;
    my $encoding = $iKernel->get_encoding(1);

    my $rfh = $iKernel->get_read_file_handle($from);
    if ($compress) {
        my $to = $from . '.utf8.gz';
        my $gz = Compress::Zlib::gzopen( $to, 'w' )
            or $iKernel->throw_io_exception($to);
        $gz->gzsetparams(
            Compress::Zlib::Z_BEST_COMPRESSION(),
            Compress::Zlib::Z_DEFAULT_STRATEGY(),
        );
        $gz->gzwrite($utf8bom) or $iKernel->throw_io_exception($to);
        while ( my $line = <$rfh> ) {
            $gz->gzwrite(
                $iKernel->get_encoded_str( $line, 'utf8', $encoding ) )
                or $iKernel->throw_io_exception($to);
        }
        $gz->gzclose();
    }
    else {
        my $to  = $from . '.utf8';
        my $wfh = $iKernel->get_write_file_handle($to);
        print ${wfh} $utf8bom or $iKernel->throw_io_exception($to);
        while ( my $line = <$rfh> ) {
            print $wfh $iKernel->get_encoded_str( $line, 'utf8', $encoding )
                or $iKernel->throw_io_exception($to);
        }
        close $wfh or $iKernel->throw_io_exception($to);
    }
    close $rfh or $iKernel->throw_io_exception($from);
    return 1;
}

sub _remove {
    my ( $iKernel, $from ) = @_;
    my $utf8 = $from . '.utf8';
    my $gz   = $utf8 . '.gz';

    if ( -w $utf8 ) {
        unlink $utf8 or $iKernel->throw_io_exception($utf8);
    }
    if ( -w $gz ) {
        unlink $gz or $iKernel->throw_io_exception($gz);
    }
    return 1;
}

1;
__END__
