#/*
# *  Copyright 2007-2008 hkrn <hikarin@users.sourceforge.jp>
# *
# *  Licensed under the Apache License, Version 2.0 (the "License");
# *  you may not use this file except in compliance with the License.
# *  You may obtain a copy of the License at
# *
# *      http://www.apache.org/licenses/LICENSE-2.0
# *
# *  Unless required by applicable law or agreed to in writing, software
# *  distributed under the License is distributed on an "AS IS" BASIS,
# *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# *  See the License for the specific language governing permissions and
# *  limitations under the License.
# */
#
# $Id: RSS.pm 1645 2008-02-06 15:40:18Z hikarin $
#

package Img0ch::Plugin::BBS::RSS;

use strict;
use XML::FeedPP qw();

sub generate_ver_10 {
    my ( $iApp, $plugin_id ) = @_;
    my $ctx = {};

    _get_info( $iApp, $plugin_id, $ctx );
    my $feed = XML::FeedPP::RDF->new();
    my $now  = $ctx->{now};
    my $path = $ctx->{path} . '.rdf';
    -r $path and $feed->merge($path);

    $feed->title( $ctx->{'c:title'} );
    $feed->description( $ctx->{'c:desc'} );
    $feed->link( $ctx->{'c:url'} );
    $feed->language('ja');
    $feed->pubDate($now);

    my $item = $feed->add_item( $ctx->{'i:resource'} );
    $item->title( $ctx->{'i:title'} );
    $item->pubDate($now);
    $item->description( $ctx->{'i:desc'} );
    $item->author( $ctx->{'i:author'} );

    $feed->limit_item( $ctx->{limit} );
    $feed->normalize();
    $feed->to_file($path);
    return 1;
}

sub generate_ver_20 {
    my ( $iApp, $plugin_id ) = @_;
    my $ctx = {};

    _get_info( $iApp, $plugin_id, $ctx );
    my $feed = XML::FeedPP::RSS->new();
    my $now  = $ctx->{now};
    my $path = $ctx->{path} . '.xml';
    -r $path and $feed->merge($path);

    $feed->title( $ctx->{'c:title'} );
    $feed->description( $ctx->{'c:desc'} );
    $feed->link( $ctx->{'c:url'} );
    $feed->language('ja');
    $feed->pubDate($now);

    my $item = $feed->add_item( $ctx->{'i:resource'} );
    $item->title( $ctx->{'i:title'} );
    $item->pubDate($now);
    $item->description( $ctx->{'i:desc'} );
    $item->author( $ctx->{'i:author'} );

    $feed->limit_item( $ctx->{limit} );
    $feed->normalize();
    $feed->to_file($path);
    return 1;
}

sub _get_info {
    my ( $iApp, $plugin_id, $ctx ) = @_;
    my $iBBS     = $iApp->bbs();
    my $iKernel  = $iApp->kernel();
    my $iConfig  = $iKernel->get_config();
    my $iRequest = $iApp->request();
    my $iSetting = $iApp->setting();
    my $iThread  = $iApp->thread();
    my $encoding = $iKernel->get_encoding(1);

    $ctx->{'c:url'} = $iBBS->url() . '/';
    $ctx->{'c:title'}
        = $iKernel->get_encoded_str( $iSetting->get('BBS_TITLE'),
        'utf8', $encoding );
    $ctx->{'c:desc'}
        = $iKernel->get_encoded_str( $iSetting->get('BBS_SUBTITLE'),
        'utf8', $encoding );
    $ctx->{'i:resource'} = join '/', $iRequest->get_app_uri(), 'read.cgi',
        $iBBS->get_name(), $iThread->get_key(), $iThread->count();
    $ctx->{path} = $iBBS->path('index');
    $ctx->{'i:author'}
        = $iKernel->get_encoded_str( $iApp->get_name(), 'utf8', $encoding );
    $ctx->{'i:desc'}
        = $iKernel->get_encoded_str( $iApp->get_comment(), 'utf8',
        $encoding );
    $ctx->{'i:title'}
        = $iKernel->get_encoded_str( $iThread->get_subject(), 'utf8',
        $encoding );
    $ctx->{limit} = -1 * (
        Img0ch::Kernel::intval(
            shift @{ $iApp->get_plugin_config( $plugin_id, 'max', 1 ) }
            )
            || 10
    );
    $ctx->{now} = $iRequest->now();
    return;
}

1;
__END__
