#/*
# *  Copyright 2007-2008 hkrn <hikarin@users.sourceforge.jp>
# *
# *  Licensed under the Apache License, Version 2.0 (the "License");
# *  you may not use this file except in compliance with the License.
# *  You may obtain a copy of the License at
# *
# *      http://www.apache.org/licenses/LICENSE-2.0
# *
# *  Unless required by applicable law or agreed to in writing, software
# *  distributed under the License is distributed on an "AS IS" BASIS,
# *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# *  See the License for the specific language governing permissions and
# *  limitations under the License.
# */
#
# $Id: Cap.pm 1645 2008-02-06 15:40:18Z hikarin $
#

package Img0ch::Compat::Cap;

use strict;
use Zeromin::Cap qw();

sub update {
    my ($iBBS) = @_;

    my $iKernel  = $iBBS->get_kernel();
    my $zCap     = Zeromin::Cap->new($iBBS);
    my $base     = $iKernel->get_config()->get('BBSPath');
    my $encoding = $iKernel->get_encoding(1);

    my $cgroup = $base . '/test/info/groupc.cgi';
    if ( -r $cgroup ) {
        my $fh = $iKernel->get_read_file_handle($cgroup);
        while ( my $line = <$fh> ) {
            chomp $line;
            my ( $name, $bbs_dir, undef, $rt ) = split '<>', $line;
            $zCap->get_group_id($name) and next;

            my $privilege = 0;
            my $bbs_id
                = Img0ch::BBS->new( $iKernel, { bbs => $bbs_dir } )->get_id();
            _cgroup_update_privilege( \$privilege, $rt );
            $zCap->add_group(
                {   bbs => $bbs_id,
                    name =>
                        $iKernel->get_encoded_str( $name, 'utf8', 'sjis' ),
                    privilege => $privilege
                }
            );
        }
        close $fh or $iKernel->throw_io_exception($cgroup);
    }

    my $cap = $base . '/test/info/caps.cgi';
    if ( -r $cap ) {
        my $fh = $iKernel->get_read_file_handle($cap);
        while ( my $line = <$fh> ) {
            chomp $line;
            my ( undef, $cname, $pass, $gname, undef ) = split '<>', $line;
            $gname = $iKernel->get_encoded_str( $gname, 'utf8', 'sjis' );
            $zCap->add(
                {   name =>
                        $iKernel->get_encoded_str( $cname, undef, 'sjis' ),
                    pass => $pass,
                    gid  => $zCap->get_group_id($gname)
                }
            );
        }
        close $fh or $iKernel->throw_io_exception($cap);
    }

    $zCap->save();
    return 1;
}

sub _cgroup_update_privilege {
    my ( $role, $rt ) = @_;
    my $auth = {};
    my @r = index( $rt, ',' ) >= 0 ? split( ',', $rt ) : ($rt);
    map { $auth->{$_} = 1 } @r;
    $$role = 1;
    map { exists $auth->{$_} or $$role = 0 } ( 1 .. 7 );
    $auth->{15} and $$role += 2;
    $auth->{8}  and $$role += 4;
    $auth->{18} and $$role += 8;
    $auth->{10} and $$role += 16;
    $auth->{11} and $$role += 32;
    $auth->{13} and $$role += 64;
    $auth->{13} and $$role += 128;
    $auth->{15} and $$role += 256;
    $auth->{17} and $$role += 512;
    return;
}

1;
__END__
