#/*
# *  Copyright 2007 hkrn <hikarin@users.sourceforge.jp>
# *
# *  Licensed under the Apache License, Version 2.0 (the "License");
# *  you may not use this file except in compliance with the License.
# *  You may obtain a copy of the License at
# *
# *      http://www.apache.org/licenses/LICENSE-2.0
# *
# *  Unless required by applicable law or agreed to in writing, software
# *  distributed under the License is distributed on an "AS IS" BASIS,
# *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# *  See the License for the specific language governing permissions and
# *  limitations under the License.
# */
#
# $Id: LocalRule.pm 1138 2007-09-15 13:16:37Z hikarin $
#

package Zeromin2::Translate::JBBS::LocalRule;

use strict;
use Zeromin2::Translate::JBBS::Parser qw();

sub work {
    my ( $zClass, $iKernel, $argument ) = @_;
    my $zTJP = Zeromin2::Translate::JBBS::Parser->new();
    my $tree;

    $zTJP->set_url( $argument->{-url} );
    $zTJP->set_password( $argument->{-pass} || $argument->{-password} );
    if ( $zTJP->try_post_form( \$tree, 'localrule' ) ) {
        my $zMeta = $argument->{metadata};
        my $tag
            = $tree->look_down( '_tag' => 'textarea', 'name' => 'LOCALRULE' );
        my $content = join "\n", @{ $tag->content() || [] };
        $zMeta->head( \$iKernel->get_encoded_str( $content, undef, 'euc' ) );
        return 1;
    }

    return 0;
}

1;
__END__
