#/*
# *  Copyright 2007 hkrn <hikarin@users.sourceforge.jp>
# *
# *  Licensed under the Apache License, Version 2.0 (the "License");
# *  you may not use this file except in compliance with the License.
# *  You may obtain a copy of the License at
# *
# *      http://www.apache.org/licenses/LICENSE-2.0
# *
# *  Unless required by applicable law or agreed to in writing, software
# *  distributed under the License is distributed on an "AS IS" BASIS,
# *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# *  See the License for the specific language governing permissions and
# *  limitations under the License.
# */
#
# $Id: Special.pm 1546 2007-11-07 14:19:36Z hikarin $
#

package Zeromin::Thread::Special;

use strict;
use base qw(Img0ch::Subject);

sub get_utf8 {
    my ( $zTS924, $key ) = @_;
    my $iKernel = $zTS924->{_kernel};
    my ( $subject, $res ) = @{ $zTS924->get($key) };

    $subject = $iKernel->get_encoded_str( $subject, 'utf8',
        $iKernel->get_encoding(1) );

    return [ $subject, $res ];
}

sub get_latest_key {
    my ($zTS924) = @_;
    my @keys = sort { $a cmp $b } @{ $zTS924->to_array() };

    if ( my $last = pop @keys ) {
        defined $Math::BigInt::VERSION or require Math::BigInt;
        return Math::BigInt->new($last) + 1;
    }
    return '9240000001';
}

sub to_array {
    my ($zTS924) = @_;
    return [ grep {/\A924/xms} @{ $zTS924->{_order} } ];
}

sub to_array_with_page {
    my ( $zTS924, $item_per_page, $offset ) = @_;

    defined $Data::Page::VERSION or require Data::Page;
    my $entries = $zTS924->to_array();
    my $page = Data::Page->new( scalar @$entries, $item_per_page, $offset );
    return ( [ $page->splice($entries) ], $page );
}

1;
__END__
