#/*
# *  Copyright 2007 hkrn <hikarin@users.sourceforge.jp>
# *
# *  Licensed under the Apache License, Version 2.0 (the "License");
# *  you may not use this file except in compliance with the License.
# *  You may obtain a copy of the License at
# *
# *      http://www.apache.org/licenses/LICENSE-2.0
# *
# *  Unless required by applicable law or agreed to in writing, software
# *  distributed under the License is distributed on an "AS IS" BASIS,
# *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# *  See the License for the specific language governing permissions and
# *  limitations under the License.
# */
#
# $Id: Thread.pm 1546 2007-11-07 14:19:36Z hikarin $
#

package Zeromin::Log::Thread;

use strict;
use base qw(Img0ch::Filter::Thread);

sub new {
    my ( $iClass, $iBBS ) = @_;
    my $iKernel = $iBBS->get_kernel();

    bless {
        __bbs => ( $iBBS->get_name() || 'test' ),
        __rs => $iKernel->get_repos( $iKernel->get_repos_path('log') ),
    }, $iClass;
}

sub load {1}

sub all {
    my ($zLogThr) = @_;
    my $bbs       = $zLogThr->{__bbs};
    my $ret       = [];
    my @data = split "\n", $zLogThr->{__rs}->get_binary("I:F:T#2.${bbs}");

    for my $one (@data) {
        my ( $ip_group, $time, $ip ) = split "\t", $one, 3;
        push @$ret,
            {
            atime    => $time,
            ip       => $ip,
            ip_group => $ip_group,
            };
    }

    return $ret;
}

sub all_with_page {
    my ( $zLogThr, $item_per_page, $offset ) = @_;

    defined $Data::Page::VERSION or require Data::Page;
    my $entries = $zLogThr->all();
    my $page = Data::Page->new( scalar @$entries, $item_per_page, $offset );
    return ( [ $page->splice($entries) ], $page );
}

1;
__END__
