#/*
# *  Copyright 2007 hkrn <hikarin@users.sourceforge.jp>
# *
# *  Licensed under the Apache License, Version 2.0 (the "License");
# *  you may not use this file except in compliance with the License.
# *  You may obtain a copy of the License at
# *
# *      http://www.apache.org/licenses/LICENSE-2.0
# *
# *  Unless required by applicable law or agreed to in writing, software
# *  distributed under the License is distributed on an "AS IS" BASIS,
# *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# *  See the License for the specific language governing permissions and
# *  limitations under the License.
# */
#
# $Id: Setting.pm 1136 2007-09-15 13:14:28Z hikarin $
#

package Zeromin2::Translate::JBBS::Setting;

use strict;
use Zeromin2::Translate::JBBS::Parser qw();

sub work {
    my ( $zClass, $iKernel, $argument ) = @_;
    my $zTJP = Zeromin2::Translate::JBBS::Parser->new();
    my $tree;

    $zTJP->set_url( $argument->{-url} );
    $zTJP->set_password( $argument->{-pass} || $argument->{-password} );
    if ( $zTJP->try_post_form( \$tree, 'main' ) ) {
        my $zSetting = $argument->{setting};
        my $alias    = {
            'BBS_LOCALRULE_COLOR'       => 'BBS_MENU_COLOR',
            'MOBILE_NORMAL_RES_LINE'    => 'BBS_MB_LINE_NUMBER',
            'MOBILE_DISP_RES_NUMBER'    => 'BBS_MB_CONTENTS_NUMBER',
            'MOBILE_DISP_THREAD_NUMBER' => 'BBS_MB_THREAD_NUMBER',
            'BBS_THREAD_STOP'           => 'BBS_RES_MAX',
        };
        for my $type ( 'text', 'checkbox' ) {
            for my $tag (
                $tree->look_down( '_tag' => 'input', 'type' => $type ) )
            {
                my $key = $tag->attr('name');
                my $value
                    = $iKernel->get_encoded_str( $tag->attr('value'), undef,
                    'euc' );
                $type eq 'checked' and !$tag->attr('checked') and $value = '';
                exists $alias->{$key} and $key = $alias->{$key};
                $zSetting->set( $key, $value );
            }
        }
        my $treats = {
            'BBS_DISP_IP' => sub {
                my ( $key, $value ) = @_;
                my $value2key = {
                    NONE => 'BBS_NO_ID',
                    ID   => 'BBS_FORCE_ID',
                    HOST => 'BBS_DISP_IP',
                };
                return ( ( $value2key->{ $value || '' } || '' ), 'checked' );
            },
        };
        for my $tag ( $tree->look_down( '_tag' => 'option' ) ) {
            $tag->attr('selected') or next;
            my $key = $tag->parent()->attr('name');
            my $value = $iKernel->get_encoded_str( $tag->attr('value'), undef,
                'euc' );
            if ( exists $treats->{$key} ) {
                my ( $key, $value ) = $treats->{$key}->($value);
                $zSetting->set( $key, $value );
            }
        }
        $zSetting->save();

        return 1;
    }

    return 0;
}

1;
__END__
