#/*
# *  Copyright 2007 hkrn <hikarin@users.sourceforge.jp>
# *
# *  Licensed under the Apache License, Version 2.0 (the "License");
# *  you may not use this file except in compliance with the License.
# *  You may obtain a copy of the License at
# *
# *      http://www.apache.org/licenses/LICENSE-2.0
# *
# *  Unless required by applicable law or agreed to in writing, software
# *  distributed under the License is distributed on an "AS IS" BASIS,
# *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# *  See the License for the specific language governing permissions and
# *  limitations under the License.
# */
#
# $Id: NoNude.pm 1481 2007-10-24 14:13:30Z hikarin $
#

package Img0ch::Plugin::Upload::NoNude;

use strict;
use XML::TreePP qw();

my $API = 'http://www.trynt.com/image-nudity-api/v1/';

sub check {
    my ($iApp)  = @_;
    my $iUpload = $iApp->upload();
    my $tree    = XML::TreePP->new();
    my $url     = $API . '?u=' . $iUpload->get_uploaded_file_url() . '&c=0';
    my $result = $tree->parsehttp( GET => $url )->{Trynt};

    if ( $result->{'Error'} ne 'true' ) {
        my $detail = $result->{'Image-Nudity-Details'};
        if ( $detail->{'Likely-Nude'} eq 'High' ) {
            my $reason
                = 'It\'s a nudity image ( score: '
                . $detail->{'Score'}
                . '; md5: '
                . $detail->{'MD5'} . ' )';
            $iApp->set_error('UPLOAD_UNEXPECTED_FILE');
            $iApp->set_error_argument( { REASON => $reason, } );
            return 0;
        }
    }
    else {
        $iApp->kernel()
            ->throw_exception( '[ ', __PACKAGE__, ' - ERROR ] ',
            $result->{Msg} );
    }
    return 1;
}

1;
__END__
