/*
 *  Copyright 2007 hkrn <hikarin@users.sourceforge.jp>
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 *
 * Img0ch.App.UFM
 * $Id: ufm.js 1425 2007-10-18 13:19:34Z hikarin $
 *
 * @require jquery.js
 * @require jquery/block.js
 * @require img0ch/app.js
 */

var Img0ch;
if ( typeof Img0ch == "undefined" ) Img0ch = {};
if ( typeof Img0ch.App == "undefined" ) Img0ch.App = {};

Img0ch.App.UFM = (function(){
    var app        = Img0ch.App;
    var bbs_       = app.getBBS();
    var cgiURI_    = app.getCGIURI();
    var staticURI_ = app.getStaticURI();
    var createUI_  = function( key, resno ) {
        var uri = cgiURI_ + "/img0ch-ufm.cgi/"
            + bbs_ + "/" + key + "/" + resno;
        var dform = jQuery(document.createElement("form")).attr({
            "action": "#", "method": "post" });
        dform.append("<p>[<a href='javascript:void(0)' "
            + "onclick='jQuery.unblockUI()'>×</a>]"
            + "&nbsp;削除パスを入力してください"
            + "<input type='password' name='pass'>&nbsp;"
            + "<input type='submit' value='送信'></p><p>"
            + "<a href='javascript:void(0)' onclick='window.open(\""
            + uri + "\")'>添付ファイル管理を開く</a><br>"
            + "(新しいウィンドウで開きます)</p>");
        dform.submit(function(){
            var pass = jQuery(
                "input[name='pass']", this ).attr("value");
            if (!pass) { return false }
            jQuery.blockUI("<h3>問い合わせ中...</h3>");
            jQuery.ajax({
                "data": {
                    "bbs": bbs_,
                    "key": key,
                    "resno": resno,
                    "pass": pass,
                    "type": "remove",
                    "js": 1
                },
                "dataType": "json",
                "error": function( xml, errorType, errorObject ) {
                    alert(xml.status + " " + xml.statusText);
                    jQuery.unblockUI();
                },
                "global": false,
                "success": function(data) {
                    if (data.ok) {
                        alert("指定されたファイルを削除しました");
                    }
                    else {
                        alert("削除出来ませんでした。"
                            + "パスが間違っているか、設定されていません");
                    }
                    jQuery.unblockUI();
                },
                "type": "POST",
                "url": uri
            });
            return false;
        });
        var dialog = jQuery(document.createElement("div"));
        dialog.attr({ "id": "i0_remove_form" });
        dialog.css({ "display": "none" });
        dialog.append(dform);
        dialog.appendTo(document.body);
        jQuery.extend( jQuery.blockUI.defaults, { "fadeOut": 0 } );
        jQuery.blockUI(dialog);
    }

    return {
    "removeFile": function( element, key, resno ) {
        if (!jQuery.blockUI) {
            app.require(
                [
                    {
                        "jQuery.blockUI":
                        staticURI_ + "/js/jquery/block.js"
                    }
                ],
                createUI_,
                key,
                resno
            );
        }
        else {
            createUI_( key, resno );
        }
        return;
    }
    };
})();
