#/*
# *  Copyright 2007 hkrn <hikarin@users.sourceforge.jp>
# *
# *  Licensed under the Apache License, Version 2.0 (the "License");
# *  you may not use this file except in compliance with the License.
# *  You may obtain a copy of the License at
# *
# *      http://www.apache.org/licenses/LICENSE-2.0
# *
# *  Unless required by applicable law or agreed to in writing, software
# *  distributed under the License is distributed on an "AS IS" BASIS,
# *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# *  See the License for the specific language governing permissions and
# *  limitations under the License.
# */
#
# $Id: Banner.pm 1481 2007-10-24 14:13:30Z hikarin $
#

package Zeromin2::Translate::Img0ch::v2::Banner;

use strict;
use Zeromin::Metadata qw();

sub work {
    my ( $zClass, $iKernel ) = @_;

    my $zMeta = Zeromin::Metadata->new($iKernel);
    my $base  = $iKernel->get_config()->get('BBSPath');
    my $ret   = { code => 0 };

    my $main = $base . '/test/info/bannerpc.cgi';
    $ret->{main}
        = _parse( $iKernel, $zMeta, 'main_banner', $main )
        ? 1
        : 0;
    my $sub = $base . '/test/info/bannersub.cgi';
    $ret->{sub}
        = _parse( $iKernel, $zMeta, 'sub_banner', $sub )
        ? 1
        : 0;
    my $mobile = $base . '/test/info/bannermb.cgi';
    $ret->{mobile}
        = _parse( $iKernel, $zMeta, 'mobile_banner', $mobile ) ? 1 : 0;

    return $ret;
}

sub _parse {
    my ( $iKernel, $zMeta, $method, $path ) = @_;
    -r $path or return 0;

    my $fh      = $iKernel->get_read_file_handle($path);
    my $color   = <$fh>;
    my $content = do { local $/ = undef; <$fh> };
    close *FH or $iKernel->throw_io_exception($path);

    $content = $iKernel->get_encoded_str( $content, undef, 'sjis' );
    $zMeta->$method( \$content );

    return 1;
}

1;
__END__
