#/*
# *  Copyright 2007 hkrn <hikarin@users.sourceforge.jp>
# *
# *  Licensed under the Apache License, Version 2.0 (the "License");
# *  you may not use this file except in compliance with the License.
# *  You may obtain a copy of the License at
# *
# *      http://www.apache.org/licenses/LICENSE-2.0
# *
# *  Unless required by applicable law or agreed to in writing, software
# *  distributed under the License is distributed on an "AS IS" BASIS,
# *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# *  See the License for the specific language governing permissions and
# *  limitations under the License.
# */
#
# $Id: XCSV.pm 1184 2007-09-25 14:06:21Z hikarin $
#

package Img0ch::Plugin::Upload::XCSV;

use strict;

sub new {
    my ( $iClass, $iBBS, $key, $called ) = @_;
    $called eq 'iterator' or return;

    bless {
        __kernel => $iBBS->get_kernel(),
        __thread => $iBBS->get_thread_instance($key),
        __upload => $iBBS->get_upload_instance($key),
    }, $iClass;
}

sub generate {
    my ($iApp) = @_;
    _process( $iApp->kernel(), $iApp->upload(),
        $iApp->thread()->count() + 1 );
    return 1;
}

*batch = \&repair;

sub repair {
    my ( $iObject, $key ) = @_;
    my $iKernel = $iObject->{__kernel};
    my $iThread = $iObject->{__thread};
    my $iUpload = $iObject->{__upload};
    $iThread->set_key($key);
    $iUpload->set_key($key);
    _process( $iKernel, $iUpload, $iThread->count() );
    return 1;
}

sub _process {
    my ( $iKernel, $iUpload, $max ) = @_;
    $iUpload->update_csv($max);
    return 1;
}

1;
__END__
