/*
 *  Copyright 2007 hkrn <hikarin@users.sourceforge.jp>
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 *
 * Img0ch.Template.Default
 * $Id: popup.js 1425 2007-10-18 13:19:34Z hikarin $
 *
 * @require img0ch/app/read.js
 * @require domTT/domLib.js
 * @require domTT/domTT.js
 */

var Img0ch;
if ( typeof Img0ch == "undefined" ) Img0ch = {};

Img0ch.Popup = (function(){
    return {
    "popupRes": function( parentObject, reses, i, key ) {
        var content = "<dt>";
        var dt = document.getElementById("rdt_" + key + "_" + i);
        var res = reses[i - 1];
        if ( !res || !res[0] ) return "";
        if ( dt ) {
            content += dt.innerHTML;
        }
        else {
            var mail = res[1];
            if (mail) {
                content += String(i) + " ：<a href=\"mailto:" + mail
                        + "\"><b>" + res[0] + "</b></a> ：" + res[2];
            }
            else {
                content = String(i) + " ：<span class=\"ResName\"><b>"
                        + res[0] + "</b></span> ：" + res[2];
            }
        }
        content += "</dt><dd>";
        var dd = document.getElementById("rdd_" + key + "_" + i);
        if ( dd ) {
            content += parentObject.rewrite( i, dd.innerHTML );
        }
        else {
            content += parentObject.rewrite( i, res[3] ) + "<br /><br />";
        }
        content += "</dd>";
        return content;
    }
    };
})();
