#/*
# *  Copyright 2007 hkrn <hikarin@users.sourceforge.jp>
# *
# *  Licensed under the Apache License, Version 2.0 (the "License");
# *  you may not use this file except in compliance with the License.
# *  You may obtain a copy of the License at
# *
# *      http://www.apache.org/licenses/LICENSE-2.0
# *
# *  Unless required by applicable law or agreed to in writing, software
# *  distributed under the License is distributed on an "AS IS" BASIS,
# *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# *  See the License for the specific language governing permissions and
# *  limitations under the License.
# */
#
# $Id: VIP.pm 1230 2007-10-01 13:40:05Z hikarin $
#

package Img0ch::Plugin::BBS::VIP;

use strict;
require 'Vip_quality.pl';    ## no critic

sub rewrite {
    my ($iApp)   = @_;
    my $iRequest = $iApp->request();
    my $bbs      = $iRequest->bbs();
    my $key      = $iRequest->key();
    my $name     = $iApp->get_name();

    if ( $iApp->is_make_new_thread() ) {
        my $renamed
            = Vip_quality::vip_quality_new_treed( $name, $bbs, $key, );
        if ( $iApp->cap()->can_add_cap_name() ) {
            my $atmark = $iApp->config()->get('multibyte.ATMARK')
                || pack( 'C*', ( 0x81, 0x97 ) );
            $renamed =~ s/\A$atmark//xms;
        }
        $iApp->set_name($renamed);
    }
    else {
        my $mail    = $iApp->get_mail();
        my $comment = $iApp->get_comment();
        my @ret     = Vip_quality::vip_quality( $name, $mail, '', $comment,
            $iRequest->signature(), $bbs, $key, );
        $iApp->set_name( $ret[0] );
        $iApp->set_mail( $ret[1] );
        $iApp->set_comment( $ret[3] );
    }
    return 1;
}

1;
__END__
