/*
 *  Copyright 2007 hkrn <hikarin@users.sourceforge.jp>
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 *
 * Img0ch.App.GoogleGears
 * $Id: googlegears.js 1257 2007-10-03 15:12:33Z hikarin $
 *
 * @require jquery.js
 * @require img0ch/app.js
 */

var Img0ch;
if ( typeof Img0ch == "undefined" ) Img0ch = {};
if ( typeof Img0ch.App == "undefined" ) Img0ch.App = {};

Img0ch.App.GoogleGears = (function(){
    var app        = Img0ch.App;
    var bbs_       = app.getBBS();
    var bbsURI_    = app.getBBSURI();
    var frequency_ = 16;

    return {
    "sync": function() {
         var localServer;
         try {
             localServer
                 = google.gears.factory.create( "beta.localserver", "1.0" );
         } catch(e) {
             return;
         }
         var filesToCapture = [];
         var ns = location.host + ".img0ch." + bbs_;
         var resourceStore = localServer.openStore(ns);
         if (!resourceStore)
             resourceStore = localServer.createStore(ns);
         if ( Math.floor( Math.random() * frequency_ ) == 0 ) {
             jQuery.getJSON(
                 bbsURI_ + "/img/removed.json",
                 function(removed) {
                     var extensions = [ "jpg", "gif", "png" ];
                     for ( var i in removed ) {
                         var res          = removed[i];
                         var base         = bbsURI_ + "/img/" + res[0] + "/";
                         var fileUriBase  = base + res[1] + ".";
                         var thumbUriBase = base + "t" + res[1] + ".";
                         for ( var e in extensions ) {
                            var ext      = extensions[e];
                            var fileUri  = fileUriBase + ext;
                            var thumbUri = thumbUriBase + ext;
                            if ( resourceStore.isCaptured(fileUri) ) {
                                resourceStore.remove(fileUri);
                            }
                            if ( resourceStore.isCaptured(thumbUri) ) {
                                resourceStore.remove(thumbUri);
                            }
                         }
                     }
                 }
             );
         }
         jQuery("img.image").each(function(){ filesToCapture.push(this.src) });
         jQuery("a.i0_file,a.i0_image,a.i0_thumbnail").click(
             function(event) {
                 var element = this;
                 var fileUri = element.href;
                 if ( !resourceStore.isCaptured(fileUri) ) {
                     resourceStore.capture(
                         fileUri,
                         function( url, success, captureId ) {
                             if (success) location.href = url;
                         }
                     );
                     return false;
                 }
             }
         );
         for ( var i in filesToCapture ) {
             var file = filesToCapture[i];
             if ( !file || resourceStore.isCaptured(file) ) continue;
             resourceStore.capture( file, function(){} );
         }
    }
    };
})();
