#/*
# *  Copyright 2007 hkrn <hikarin@users.sourceforge.jp>
# *
# *  Licensed under the Apache License, Version 2.0 (the "License");
# *  you may not use this file except in compliance with the License.
# *  You may obtain a copy of the License at
# *
# *      http://www.apache.org/licenses/LICENSE-2.0
# *
# *  Unless required by applicable law or agreed to in writing, software
# *  distributed under the License is distributed on an "AS IS" BASIS,
# *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# *  See the License for the specific language governing permissions and
# *  limitations under the License.
# */
#
# $Id: icon.pm 1057 2007-09-04 14:37:43Z hikarin $
#

package Zeromin2::App::icon;

use strict;

sub load {
    my ($zApp) = @_;
    $zApp->privilege('can_edit_head') or return $zApp->return_value( 1, [] );

    my $iConfig = $zApp->kernel()->get_config();
    $zApp->add_template_param(
        {   Dir => $iConfig->get('icon.dir'),
            URL => $iConfig->get('icon.url'),
        }
    );

    require Data::Page;
    require Zeromin::Icon;
    my $zIcon   = Zeromin::Icon->new( $zApp->bbs() );
    my $entries = $zIcon->get_icon_list();
    my $page = Data::Page->new( scalar @$entries, $zApp->page_param('icon') );
    return $zApp->return_value( 0, [ $page->splice($entries) ], $page );
}

sub save {
    my ($zApp) = @_;
    $zApp->check_csrf()               or return $zApp->return_value(1);
    $zApp->privilege('can_edit_head') or return $zApp->return_value(1);

    my $iRequest    = $zApp->request();
    my $icon        = $iRequest->param('icon');
    my $name        = $iRequest->param('name');
    my $description = $iRequest->param('description');
    my $pass        = $iRequest->param('pass') || 'null';
    $name        =~ s/[\t\r\n]//gxms;
    $description =~ s/[\t\r\n]//gxms;

    require Zeromin::Icon;
    my $zIcon = Zeromin::Icon->new( $zApp->bbs() );
    if ( $zIcon->get($icon)->{extension} ) {
        $zIcon->set(
            $icon,
            {   description => $description,
                name        => $name,
                pass        => $pass,
            }
        );
        $zIcon->save();
    }
    else {
        return $zApp->return_value(2);
    }

    return $zApp->return_value(0);
}

sub edit_form {
    my ($zApp) = @_;
    $zApp->privilege('can_edit_head') or return $zApp->return_value(1);

    require Zeromin::Cap;
    require Zeromin::Icon;
    my $iBBS    = $zApp->bbs();
    my $iConfig = $zApp->kernel()->get_config();
    my $zIcon   = Zeromin::Icon->new($iBBS);
    my $icon    = $zApp->request()->param('icon');
    my $info    = $zIcon->get($icon);

    my ( $unijp, undef ) = $zApp->unijp();
    my $zCap = Zeromin::Cap->new($iBBS);
    my $pass = $info->{pass};
    my $caps = $zCap->get_caps($unijp);
    map { $_->{id} eq $pass and $_->{selected} = 1 } @$caps;

    $zApp->add_template_param(
        {   Caps        => $caps,
            Dir         => $iConfig->get('icon.dir'),
            Description => $info->{description},
            Extension   => $info->{extension},
            Height      => $info->{height},
            Id          => $icon,
            IsGlobal    => $info->{is_global},
            Name        => $info->{name},
            URL         => $iConfig->get('icon.url'),
            Width       => $info->{width},
        }
    );

    return $zApp->return_value(0);
}

sub remove {
    my ($zApp) = @_;
    $zApp->check_csrf()               or return $zApp->return_value(1);
    $zApp->privilege('can_edit_head') or return $zApp->return_value(1);

    my @param = $zApp->request()->param('icon');
    scalar @param or return $zApp->return_value(2);
    my $status = {};

    require Zeromin::Icon;
    my $zIcon = Zeromin::Icon->new( $zApp->bbs() );
    for my $icon (@param) {
        if ( $zIcon->remove($icon) ) {
            $zApp->logger( 1, 'REMOVED ICON %s', [$icon] );
            $status->{$icon} = 1;
        }
        else {
            $zApp->logger( 0, 'TRIED REMOVING ICON %s', [$icon] );
            $status->{$icon} = 0;
        }
    }

    $zIcon->save();
    return $zApp->return_value( 0, $status );
}

sub search {
    my ($zApp) = @_;
    $zApp->check_csrf()               or return $zApp->return_value(1);
    $zApp->privilege('can_edit_head') or return $zApp->return_value(1);

    require Zeromin::Icon;
    my $zIcon   = Zeromin::Icon->new( $zApp->bbs() );
    my $iConfig = $zApp->kernel()->get_config();
    my $path    = $iConfig->get('icon.dir');
    my $url     = $iConfig->get('icon.url');
    my $added   = $zIcon->search( $path, $url );
    $zApp->add_template_param( { Found => $added } );
    $zApp->logger( 1, 'ADDED NEW %d ICONS', [$added] );
    return $zApp->return_value(0);
}

1;
__END__
