#/*
# *  Copyright 2007 hkrn <hikarin@users.sourceforge.jp>
# *
# *  Licensed under the Apache License, Version 2.0 (the "License");
# *  you may not use this file except in compliance with the License.
# *  You may obtain a copy of the License at
# *
# *      http://www.apache.org/licenses/LICENSE-2.0
# *
# *  Unless required by applicable law or agreed to in writing, software
# *  distributed under the License is distributed on an "AS IS" BASIS,
# *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# *  See the License for the specific language governing permissions and
# *  limitations under the License.
# */
#
# $Id: Pool.pm 1102 2007-09-10 14:31:36Z hikarin $
#

package Zeromin2::Translate::Img0ch::v2::Pool;

use strict;
use Zeromin::BBS qw();
use Zeromin::Pool qw();
use Zeromin::Thread qw();

sub work {
    my ( $zClass, $iKernel ) = @_;

    require Zeromin::BBS;
    my $zBBS = Zeromin::BBS->new( $iKernel, { id => 0 } );
    my $bbs_all = $zBBS->all();
    foreach my $bbs (@$bbs_all) {
        my $iBBS = Img0ch::BBS->new( $iKernel, { id => $bbs->{id} } );
        _aggregate( $iKernel, $iBBS );
    }

    return { code => 0, pool => 1 };
}

sub _aggregate {
    my ( $iKernel, $iBBS ) = @_;
    my $base = $iBBS->path('pool');
    -d $base or return;

    local ( *DH, $! );
    opendir *DH, $base or $iKernel->throw_io_exception($base);
    my @dirs = readdir *DH;
    closedir *DH or $iKernel->throw_io_exception($base);

    require File::Spec;
    for my $file ( File::Spec->no_upwards(@dirs) ) {
        $file =~ m{\A(\d{9,10})\.cgi\z}xms or next;
        my $key     = $1;
        my $zThread = Zeromin::Thread->new($iBBS);
        $zThread->load( File::Spec->catfile( $base, $file ) );
        my $zPool = Zeromin::Pool->new( $zThread, $key );
        $zPool->create();
    }

    return;
}

1;
__END__
