#/*
# *  Copyright 2007 hkrn <hikarin@users.sourceforge.jp>
# *
# *  Licensed under the Apache License, Version 2.0 (the "License");
# *  you may not use this file except in compliance with the License.
# *  You may obtain a copy of the License at
# *
# *      http://www.apache.org/licenses/LICENSE-2.0
# *
# *  Unless required by applicable law or agreed to in writing, software
# *  distributed under the License is distributed on an "AS IS" BASIS,
# *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# *  See the License for the specific language governing permissions and
# *  limitations under the License.
# */
#
# $Id: Metadata.pm 1057 2007-09-04 14:37:43Z hikarin $
#

package Zeromin::Metadata;

use strict;
use base qw(Img0ch::Metadata);

BEGIN {
    my $pkg     = __PACKAGE__;
    my @methods = $pkg->method_info();

    for my $method (@methods) {
        my ( $name, $file, $is_global, $plugin_type ) = @$method;
        no strict 'refs';
        *{"${pkg}::${name}"} = sub {
            shift->_switch( $name, $file, $plugin_type, @_ );
        };
    }
}

sub new {
    my ( $zClass, $iObject ) = @_;
    my $class = ref $iObject || '';
    my ( $zMeta, $iRepos );

    if ( $class eq 'Img0ch::BBS' or $class eq 'Zeromin::BBS' ) {
        $zMeta = $zClass->SUPER::new($iObject);
    }
    elsif ( $class eq 'Img0ch::Kernel' or $class eq 'Img0ch::Maple' ) {
        $zMeta = bless {
            _bbs    => 'test',
            _kernel => $iObject,
            _common =>
                $iObject->get_repos( $iObject->get_repos_path('common') ),
        }, $zClass;
    }
    else {
        Img0ch::Kernel->throw_exception(
            'Img0ch::BBS or Img0ch::Maple(Img0ch::Kernel) not given');
    }

    $zMeta;
}

sub remove {
    my ($zMeta) = @_;
    my ( $iRepos, $dir ) = ( $zMeta->{_system}, $zMeta->{_bbs} );
    $iRepos->remove("I:M.${dir}.head");
    $iRepos->remove("I:M.${dir}.meta");
    $iRepos->remove("I:M.${dir}.foot");
    $iRepos->remove("I:M.${dir}.thread");
    $iRepos->save();
    return 1;
}

sub _switch {
    my ( $zMeta, $type, $file, $plugin_type, $content ) = @_;
    $content
        ? $zMeta->_save( $type, $file, $plugin_type, $content )
        : $zMeta->_load( $type, ( $file ? 0 : 1 ) );
}

sub _save {
    my ( $zMeta, $type, $file, $plugin_type, $content ) = @_;
    my ( $iKernel, $iReposCommon, $iReposSystem, $dir ) = (
        $zMeta->{_kernel}, $zMeta->{_common}, $zMeta->{_system},
        ( $file ? $zMeta->{_bbs} : 'test' )
    );

    require Zeromin::Plugin;
    my $zPlugin = Zeromin::Plugin->new($iKernel);
    $zPlugin->do( "zeromin.update.${plugin_type}",
        $zMeta, [ $zMeta->{_bbs}, $content ] );

    if ($file) {
        my $base = $iKernel->get_config()->get('BBSPath');
        my $path = join '/', $base, $dir, $file;
        local ( $!, *FH );
        open *FH, ">${path}"    ## no critic
            or $iKernel->throw_io_exception($path);
        print {*FH} ${$content}
            or $iKernel->throw_io_exception($path);
        close *FH or $iKernel->throw_io_exception($path);
        $iReposSystem->set_binary( "I:M.${dir}.${type}", $$content );
        $iReposSystem->save();
        $iReposCommon->remove("I:M.${dir}.${type}");
        $iReposCommon->save();
    }
    else {
        $iReposCommon->set_binary( "I:M.${type}", $$content );
        $iReposCommon->save();
    }

    return 1;
}

1;
__END__
