/*
 *  Copyright 2007 hkrn <hikarin@users.sourceforge.jp>
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 *
 * $Id: image.js 526 2007-05-01 14:14:50Z hikarin $
 *
 */

Img0ch.App.Read.Plugin.Image = (function(){
    app.require("img0ch/upload.js");

    var base    = app.getBaseURL();
    var bbs     = app.getBBS();
    var key     = app.getKey();
    var upload  = new Img0ch.Upload( base, bbs, key );
    var path    = upload.getPath();
    var ufm     = app.getCGIURI() + "/img0ch-ufm.cgi/" + bbs + "/" + key + "/";

    return {
        "rewrite": function( resno, comment ){
            var info = upload.get(resno);
            if (info[0]) {
                var extension   = info[0];
                var thumbWidth  = info[4];
                var thumbHeight = info[5];
                var file = path + '/' + resno + '.' + extension;
                if ( thumbWidth > 0 && thumbHeight > 0 ) {
                    if (/^.[^\(]+\((.[^\)]+)\)<br\s?\/?>/.test(comment)) {
                        var info = RegExp.$1;
                        var thumb = path + "/t" + resno + '.' + extension;
                        comment = comment.replace( /^.[^\(]+\(.[^\)]+\)<br\s?\/?>/, "<a href=" + file + "><img src=" + thumb + " width=" + thumbWidth + " height=" + thumbHeight + " class=image ></a>(" + info + ")<a href=" + ufm + resno + " onclick='Img0ch.App.removeFile(this," + key + "," + resno + ");return false'>[削除]</a><br>" );
                        comment += "<br class=clear>";
                    }
                }
            }
            return comment;
        }
    };
})();
