#/*
# *  Copyright 2007 hkrn <hikarin@users.sourceforge.jp>
# *
# *  Licensed under the Apache License, Version 2.0 (the "License");
# *  you may not use this file except in compliance with the License.
# *  You may obtain a copy of the License at
# *
# *      http://www.apache.org/licenses/LICENSE-2.0
# *
# *  Unless required by applicable law or agreed to in writing, software
# *  distributed under the License is distributed on an "AS IS" BASIS,
# *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# *  See the License for the specific language governing permissions and
# *  limitations under the License.
# */
#
# $Id: Upload.pm 363 2007-03-16 15:11:10Z hikarin $
#

package Img0ch::Compat::Upload;

use strict;

sub load {
    my ( $iRepos, $iBBS, $key ) = @_;
    my $base = $iBBS->path($key);
    my $path = join '/', $base, 'upload.cgi';
    -r $path or return 0;

    my $iKernel = $iBBS->get_kernel();
    my $bbs     = $iBBS->get_name();
    my $prefix  = "I:U:I.${bbs}.${key}";
    my $i       = $iRepos->get("${prefix}._");

    local ( $!, *FH );
    open *FH, "<${path}"    ## no critic
        or $iKernel->throw_io_exception($path);
    while ( my $line = <FH> ) {
        chomp $line;
        my ($resno, $extension, $width, $height, $hash,
            $rmkey, $suspend,   $ip,    $time
        ) = split ',', $line;
        my $prefix_resno = join '.', $prefix, $resno;
        if ( !$iRepos->get("${prefix_resno}.extension") ) {
            $iRepos->set( "${prefix_resno}.extension", $extension );
            $iRepos->set( "${prefix_resno}.width",     $width );
            $iRepos->set( "${prefix_resno}.height",    $height );
            $iRepos->set( "${prefix_resno}.hash",      $hash );
            my $thumbnail = "${path}/t${resno}.${extension}";
            if ( -r $thumbnail ) {
                my ( $thumb_width, $thumb_height )
                    = Img0ch::Upload->get_dimensions($thumbnail);
                $iRepos->set( "${prefix_resno}.width.thumbnail",
                    $thumb_width );
                $iRepos->set( "${prefix_resno}.height.thumbnail",
                    $thumb_height );
            }
            $i++;
        }
    }
    $iRepos->set( "${prefix}._", $i );
    close *FH or $iKernel->throw_io_exception($path);
    return 1;
}

1;
__END__
