#/*
# *  Copyright 2007 hkrn <hikarin@users.sourceforge.jp>
# *
# *  Licensed under the Apache License, Version 2.0 (the "License");
# *  you may not use this file except in compliance with the License.
# *  You may obtain a copy of the License at
# *
# *      http://www.apache.org/licenses/LICENSE-2.0
# *
# *  Unless required by applicable law or agreed to in writing, software
# *  distributed under the License is distributed on an "AS IS" BASIS,
# *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# *  See the License for the specific language governing permissions and
# *  limitations under the License.
# */
#
# $Id: BanASCII.pm 830 2007-06-16 13:34:55Z hikarin $
#

package Img0ch::Plugin::Filter::BanASCII;

use strict;

sub is_ascii_only {
    my ($iApp) = @_;

    my $ret = eval {
        require Encode;
        my $text = Encode::decode( 'shiftjis', $iApp->get_comment() );
        if ( $text =~ /\A[\x00-\xff]+\z/xms ) {
            $iApp->set_error('DENY_POSTING_ASCII_ONLY');
            return 0;
        }
        return 1;
    };
    if ($@) {
        require Unicode::Japanese;
        my $icode = Unicode::Japanese->get_code( $iApp->get_comment() );
        if ( $icode eq 'ascii' or $icode eq 'unknown' ) {
            $iApp->set_error('DENY_POSTING_ASCII_ONLY');
            return 0;
        }
        else {
            return 1;
        }
    }
    else {
        return $ret;
    }
}

1;
__END__
