#/*
# *  Copyright 2007 hkrn <hikarin@users.sourceforge.jp>
# *
# *  Licensed under the Apache License, Version 2.0 (the "License");
# *  you may not use this file except in compliance with the License.
# *  You may obtain a copy of the License at
# *
# *      http://www.apache.org/licenses/LICENSE-2.0
# *
# *  Unless required by applicable law or agreed to in writing, software
# *  distributed under the License is distributed on an "AS IS" BASIS,
# *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# *  See the License for the specific language governing permissions and
# *  limitations under the License.
# */
#
# $Id: RSS.pm 850 2007-06-23 11:39:18Z hikarin $
#

package Img0ch::Plugin::BBS::RSS;

use strict;
use Unicode::Japanese qw();
use XML::FeedPP qw();

sub generate_ver_10 {
    my ($iApp) = @_;
    my $hash = {};

    _get_info( $iApp, $hash );
    my $feed = XML::FeedPP::RDF->new();
    my $now  = $hash->{now};
    my $path = $hash->{path} . '.rdf';
    -r $path and $feed->merge($path);

    $feed->title( $hash->{'c:title'} );
    $feed->description( $hash->{'c:desc'} );
    $feed->link( $hash->{'c:url'} );
    $feed->language('ja');
    $feed->pubDate($now);

    my $item = $feed->add_item( $hash->{'i:resource'} );
    $item->title( $hash->{'i:title'} );
    $item->pubDate($now);
    $item->description( $hash->{'i:desc'} );
    $item->author( $hash->{'i:author'} );

    $feed->limit_item(10);
    $feed->normalize();
    $feed->to_file($path);
    return 1;
}

sub generate_ver_20 {
    my ($iApp) = @_;
    my $hash = {};

    _get_info( $iApp, $hash );
    my $feed = XML::FeedPP::RSS->new();
    my $now  = $hash->{now};
    my $path = $hash->{path} . '.xml';
    -r $path and $feed->merge($path);

    $feed->title( $hash->{'c:title'} );
    $feed->description( $hash->{'c:desc'} );
    $feed->link( $hash->{'c:url'} );
    $feed->language('ja');
    $feed->pubDate($now);

    my $item = $feed->add_item( $hash->{'i:resource'} );
    $item->title( $hash->{'i:title'} );
    $item->pubDate($now);
    $item->description( $hash->{'i:desc'} );
    $item->author( $hash->{'i:author'} );

    $feed->limit_item(10);
    $feed->normalize();
    $feed->to_file($path);
    return 1;
}

sub _get_info {
    my ( $iApp, $hash ) = @_;
    my $iBBS     = $iApp->bbs();
    my $iKernel  = $iApp->kernel();
    my $iConfig  = $iKernel->get_config();
    my $iRequest = $iApp->request();
    my $iSetting = $iApp->setting();
    my $iThread  = $iApp->thread();
    my $encoding = $iKernel->get_encoding(1);
    my $unijp    = Unicode::Japanese->new();

    $hash->{'c:url'} = $iBBS->url() . '/';
    $hash->{'c:title'}
        = $unijp->set( $iSetting->get('BBS_TITLE'), $encoding )->get();
    $hash->{'c:desc'}
        = $unijp->set( $iSetting->get('BBS_SUBTITLE'), $encoding )->get();
    $hash->{'i:resource'} = join '/', $iRequest->get_app_uri(), 'read.cgi',
        $iBBS->get_name(), $iThread->get_key(), ( $iThread->count + 1 );
    $hash->{path} = $iBBS->path('index');
    $hash->{'i:author'} = $unijp->set( $iApp->get_name(), $encoding )->get();
    $hash->{'i:desc'} = $unijp->set( $iApp->get_comment(), $encoding )->get();
    $hash->{'i:title'}
        = $unijp->set( $iThread->get_subject(), $encoding )->get();
    $hash->{now} = time();
    return;
}

1;
__END__
