#/*
# *  Copyright 2007 hkrn <hikarin@users.sourceforge.jp>
# *
# *  Licensed under the Apache License, Version 2.0 (the "License");
# *  you may not use this file except in compliance with the License.
# *  You may obtain a copy of the License at
# *
# *      http://www.apache.org/licenses/LICENSE-2.0
# *
# *  Unless required by applicable law or agreed to in writing, software
# *  distributed under the License is distributed on an "AS IS" BASIS,
# *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# *  See the License for the specific language governing permissions and
# *  limitations under the License.
# */
#
# $Id: DNSBL.pm 802 2007-06-10 12:47:54Z hikarin $
#

package Img0ch::Plugin::Filter::DNSBL;

use strict;

sub check_by_bbq {
    _check_proxy( '%d.%d.%d.%d.niku.2ch.net', @_ );
}

sub check_by_bbx {
    _check_proxy( '%d.%d.%d.%d.bbx.2ch.net', @_ );
}

sub check_by_dsbl {
    _check_proxy( '%d.%d.%d.%d.list.dsbl.org', @_ );
}

sub by_rbl {
    _check_proxy( '%d.%d.%d.%d.all.rbl.jp', @_ );
}

sub by_spamcop {
    _check_proxy( '%d.%d.%d.%d.bl.spamcop.net', @_ );
}

sub by_spamhaus {
    _check_proxy( '%d.%d.%d.%d.sbl-xbl.spamhaus.org', @_ );
}

sub by_blitzed {

    #    service was stopped
    #    _check_proxy( '%d.%d.%d.%d.opm.blitzed.org', @_ );
    return 1;
}

sub by_empty {
    _check_proxy( '%d.%d.%d.%d.bsb.empty.us', @_ );
}

sub by_spamlookup {
    _check_proxy( '%d.%d.%d.%d.bsb.spamlookup.net', @_ );
}

sub _check_proxy {
    my ( $base, $iApp ) = @_;
    my $addr = sprintf $base, ( reverse split '\.', $iApp->get_ip() );

    if ( gethostbyname($addr) ) {
        if ( $iApp->setting()->is_checked('BBS_OVERSEA_PROXY') ) {
            $iApp->cap()->can_pass_proxy_access() and return 1;
            $iApp->set_error('DENY_FROM_PROXY_ACCESS');
            return 0;
        }
        else {
            my $name = $iApp->get_name();
            if ( $name !~ /<\/b>\[-{}\@{}\@{}-\]<b>/xms ) {
                $name = '</b>[-{}@{}@{}-]<b> ' . $name;
                $iApp->set_name($name);
            }
        }
    }
    return 1;
}

1;
__END__
