#/*
# *  Copyright 2007 hkrn <hikarin@users.sourceforge.jp>
# *
# *  Licensed under the Apache License, Version 2.0 (the "License");
# *  you may not use this file except in compliance with the License.
# *  You may obtain a copy of the License at
# *
# *      http://www.apache.org/licenses/LICENSE-2.0
# *
# *  Unless required by applicable law or agreed to in writing, software
# *  distributed under the License is distributed on an "AS IS" BASIS,
# *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# *  See the License for the specific language governing permissions and
# *  limitations under the License.
# */
#
# $Id: Icon.pm 802 2007-06-10 12:47:54Z hikarin $
#

package Img0ch::Plugin::BBS::Icon;

use strict;

sub new {
    my ( $iClass, $iBBS, $key, $called ) = @_;
    $called eq 'iterator' or return;

    require Img0ch::Icon;
    my $iConfig = $iBBS->get_kernel()->get_config();
    my $iIcon   = Img0ch::Icon->new($iBBS);
    bless {
        __bbs     => $iBBS->get_name(),
        __end_tag => ( $iConfig->get('EnableXHTMLBreak') ? ' />' : '>' ),
        __icon    => $iIcon,
        __url     => $iConfig->get('icon.url'),
    }, $iClass;
}

sub save {
    my ($iApp)   = @_;
    my $iRequest = $iApp->request();
    my $path     = $iApp->config()->get('icon.url');

    require Img0ch::Icon;
    my $iIcon     = Img0ch::Icon->new( $iApp->bbs() );
    my $icon      = $iRequest->param('icon');
    my $icon_info = $iIcon->get($icon);
    if ( $icon_info->{extension} ) {
        my $p = $icon_info->{pass} || 'null';
        if ( $p eq 'null' or ( $p eq $iApp->cap()->get_pass_md5() ) ) {
            if ( !$icon_info->{is_global} ) {
                $path !~ m{/\z}xms and $path .= '/';
                $path .= $iApp->bbs()->get_name();
            }
            my $text = $iApp->get_comment();
            my $temp
                = '<!--icon src="'
                . Img0ch::Kernel::escape_html_entities($path) . '/'
                . $icon . '.'
                . $icon_info->{extension} . '"-->';
            if ( $iRequest->fsize() ) {
                my @line = split '<br>', $text;
                splice @line, 1, 0, $temp;
                $text = join '<br>', @line;
            }
            else {
                $text = $temp . $text;
            }
            $iApp->set_comment($text);
        }
    }
    return 1;
}

sub add_tag_on_bbs { _add_tag( $_[0], 'add_index_tag' ) }

sub add_tag_on_read { _add_tag( $_[0], 'add_read_tag' ) }

sub _add_tag {
    my ( $iApp, $method ) = @_;
    require Img0ch::Icon;
    my $iIcon = Img0ch::Icon->new( $iApp->bbs() );
    $iApp->$method(
        {   Icon  => $iIcon->count(),
            Icons => $iIcon->get_icon_list(),
        }
    );
    return 1;
}

sub rewrite {
    my ( $iObject, $key, $count, $resno, $text ) = @_;
    my $iIcon = $iObject->{__icon};

    if ( $$text =~ m{<!--icon\s+src=".+/([^\.]+)\.\w+"-->}xms ) {
        my $icon_id        = $1;
        my $icon_info      = $iIcon->get($icon_id);
        my $icon_img_alt   = $icon_info->{name};
        my $icon_extension = $icon_info->{extension};
        my $icon_width     = $icon_info->{width};
        my $icon_height    = $icon_info->{height};
        my $icon_url       = $iObject->{__url};
        my $icon_dir
            = $icon_info->{is_global} ? '' : ( '/' . $iObject->{__bbs} );
        my $end_tag = $iObject->{__end_tag};
        $$text =~ s{<!--icon\s+src=".+/[^\.]+\.\w+"-->}
        {<img class="image" style="vertical-align:top; float:left;" src="${icon_url}${icon_dir}/${icon_id}.${icon_extension}" alt="${icon_img_alt}" width="${icon_width}" height="${icon_height}"${end_tag}<div style="float:left">}xms;
        $$text .= '</div><br style="clear:both"' . $end_tag;

#        $$text =~ s{<!--icon\s+src=".+/[^\.]+\.\w+"-->}
#        {<table border="0" class="icon"><tr><td valign="top"><img src="${icon_url}/${icon_id}.${icon_extension}" alt="${icon_img_alt}" width="${icon_width}" height="${icon_height}" /></td><td valign="top">}xms;
#        $$text .= '</td></tr></table>';
    }
    return;
}

*from_bbs = \&rewrite;

*from_read = \&rewrite;

1;
__END__
