/*
 *  Copyright 2007 hkrn <hikarin@users.sourceforge.jp>
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 *
 *  $Id: respreview.js 377 2007-03-18 14:30:14Z hikarin $
 *
 *  @require jquery.js
 *
 */

var Zeromin2;
if (!Zeromin2) Zeromin2 = {};

Zeromin2.ResPreview = function(property) {
    var formId = property.formID;
    var staticURI = property.staticURI;
    var typeTheme = property.typeTheme;
    var isTypeTheme = property.isTypeTheme;

    var formContainer = jQuery("form#" + formId);
    var formContainerWidth = formContainer.width();
    var formContainerHeight = formContainer.height();
    formArea = jQuery("textarea[@name='MESSAGE']").width(
        Math.round( ( formContainerWidth * 9.5 ) / 10 )).height(
        Math.round(formContainerHeight / 2));

    var previewFrame = jQuery("#previewFrame").show();
    var frameElement = jQuery( "iframe", previewFrame ).show().width(
        Math.round( ( formContainerWidth * 9.5 ) / 10 )).height(
        Math.round(formContainerHeight / 2)).css({
        "border": "1px solid #666" }).get(0);

    var frame = jQuery.browser.msie
        ? frameElement.contentWindow.document
        : frameElement.contentDocument;

    if (!property.noHeader) {
        var url;
        if (isTypeTheme) {
            url = staticURI + "/tdiary/" 
                + typeTheme + "/" + typeTheme + ".css";
        }
        else {
            url = staticURI + "/css/bbs.css";
        }
        var css = frame.createElement("link");
        css.rel = "stylesheet"; 
        css.type = "text/css";
        css.href = url;
        jQuery( "head", frame ).append(css);
    }

    var frameBody = frame.body;
    frameBody.innerHTML =   
        "<div class='day'><div class='body thread_body'>"
        + "<div class='thread_reses'><div class='section'>"
        + "</div><div class='caption res_header'>"
        + "名前：<span class='commentator' id='preview_FROM'></span>："
        + "<span class='commenttime' id='preview_date'>"
        + property.date + "</span></div>"
        + "<p class='res_body' id='preview_MESSAGE'>"
        + property.text + "</p></div></div></div>";

    var previewFROM = jQuery( "p#preview_FROM", frameBody ).get(0);
    var previewDATE = jQuery( "p#preview_date", frameBody ).get(0);
    var previewMESSAGE = jQuery( "p#preview_MESSAGE", frameBody ).get(0);
    var fromForm = jQuery("input[@name='FROM']");
    var mailForm = jQuery("input[@name='mail']");
    var dateForm = jQuery("input[@name='date']");
    var feedback = function() {
        var unescapeHTML = function(string) {
            if (!string) return;
            return string.replace(
                /&lt;/g, "<" ).replace( /&gt;/g, ">" ).replace(
                /&quot;/g, "\"" ).replace( /&#39;/g, "'" ).replace(
                /&amp;/g, "&" ).replace( /\n/g, "<br>" );
        };
        try {
            var from = unescapeHTML(fromForm.attr("value"));
            var mail = unescapeHTML(mailForm.attr("value"));
            if (mail) {
                previewFROM.innerHTML = "<a href='mailto:" + mail
                    + "' rel='nofollow'><b>" + from + "</b></a>";
            }
            else {
                previewFROM.innerHTML = from;
            }
            previewDATE.innerHTML = unescapeHTML(dateForm.attr("value"));
            previewMESSAGE.innerHTML = unescapeHTML(formArea.attr("value"));
        } catch(e) {
            Zeromin2.sendError(e);
        }
    };
    formArea.blur(feedback);
    fromForm.blur(feedback);
    mailForm.blur(feedback);
    dateForm.blur(feedback);
    feedback();
};
