#/*
# *  Copyright 2007 hkrn <hikarin@users.sourceforge.jp>
# *
# *  Licensed under the Apache License, Version 2.0 (the "License");
# *  you may not use this file except in compliance with the License.
# *  You may obtain a copy of the License at
# *
# *      http://www.apache.org/licenses/LICENSE-2.0
# *
# *  Unless required by applicable law or agreed to in writing, software
# *  distributed under the License is distributed on an "AS IS" BASIS,
# *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# *  See the License for the specific language governing permissions and
# *  limitations under the License.
# */
#
# $Id: plugin.pm 610 2007-05-09 14:49:15Z hikarin $
#

package Zeromin2::App::plugin;

use strict;
use Zeromin::Plugin qw();

sub load {
    my ( $zApp, $callFromBBS ) = @_;
    $zApp->privilege( 'can_enter_plugin_section', $callFromBBS )
        or return $zApp->return_value( 1, [] );

    require Img0ch::BBS;
    my $zPluginBBS;
    my $zPluginGlobal = Zeromin::Plugin->new( $zApp->kernel() );
    $zPluginGlobal->load();

    my $bbs_id = 0;
    if ( my $iBBS = $zApp->bbs() ) {
        $bbs_id     = $iBBS->get_id();
        $zPluginBBS = Zeromin::Plugin->new($iBBS);
        $zPluginBBS->load();
    }

    my ( $content, $page, $class )
        = $zPluginGlobal->filter_with_page( $zPluginBBS,
        ( $zApp->request()->param('query') || '' ),
        $zApp->page_param() );
    $zApp->add_template_param( { PluginClasses => $class } );
    return $zApp->return_value( 0, $content, $page );
}

sub save {
    my ( $zApp, $callFromBBS ) = @_;
    $zApp->check_csrf() or return $zApp->return_value(1);
    $zApp->privilege( 'can_regist_plugin', $callFromBBS )
        or return $zApp->return_value(1);
    my $iRequest = $zApp->request();

    require Img0ch::BBS;
    my $zPlugin = Zeromin::Plugin->new( $zApp->bbs() || $zApp->kernel() );
    $zPlugin->load();
    my @enable     = $iRequest->param('id');
    my @plugin_ids = $iRequest->param('plugin');
    my $ret        = { enable => 0, disable => 0 };
    my %enable_seen;
    map { $enable_seen{$_} = 1 } @enable;

    for my $plugin_id (@plugin_ids) {
        if ( exists $enable_seen{$plugin_id} ) {
            $zPlugin->enable($plugin_id);
            $ret->{enable}++;
        }
        else {
            $zPlugin->disable($plugin_id);
            $ret->{disable}++;
        }
    }
    $zPlugin->save();

    $zApp->add_template_param(
        {   Disabled => $ret->{disable},
            Enabled  => $ret->{enable}
        }
    );
    return $zApp->return_value(0);
}

sub search { _search( 0, @_ ) }

sub install { _search( 0, @_ ) }

sub uninstall { _search( 1, @_ ) }

sub _search {
    my ( $is_uninstall, $zApp ) = @_;
    $zApp->check_csrf()                   or return $zApp->return_value(1);
    $zApp->privilege('can_regist_plugin') or return $zApp->return_value(1);

    require Zeromin::BBS;
    my $iKernel       = $zApp->kernel();
    my $zBBS          = Zeromin::BBS->new( $iKernel, { id => 0 } );
    my $zPluginGlobal = Zeromin::Plugin->new($iKernel);

    $zPluginGlobal->load();
    my $found = $zPluginGlobal->search( '', $is_uninstall );
    $zPluginGlobal->save();

    my $bbs_range = $zApp->user()->get_current_user()->{bbs};
    my $array
        = $bbs_range
        ? $zBBS->get($bbs_range)
        : $zBBS->all();

    for my $bbs ( @{$array} ) {
        my $zPlugin = Zeromin::Plugin->new( $zApp->kernel );
        $zPlugin->set_bbs_id( $bbs->{id} );
        $zPlugin->copy($zPluginGlobal);
        $zPlugin->save();
    }

    $zApp->add_template_param( { Found => $found } );
    return $zApp->return_value(0);
}

1;
__END__
