#/*
# *  Copyright 2007 hkrn <hikarin@users.sourceforge.jp>
# *
# *  Licensed under the Apache License, Version 2.0 (the "License");
# *  you may not use this file except in compliance with the License.
# *  You may obtain a copy of the License at
# *
# *      http://www.apache.org/licenses/LICENSE-2.0
# *
# *  Unless required by applicable law or agreed to in writing, software
# *  distributed under the License is distributed on an "AS IS" BASIS,
# *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# *  See the License for the specific language governing permissions and
# *  limitations under the License.
# */
#
# $Id: Special.pm 622 2007-05-12 13:36:27Z hikarin $
#

package Zeromin::Thread::Special;

use strict;
use base qw(Img0ch::Subject);

sub get_latest_key {
    my ( $zTS924 ) = @_;
    my @keys = sort { $a cmp $b } @{$zTS924->to_array()};

    if ( my $last = pop @keys ) {
        require Math::BigInt;
        return Math::BigInt->new($last) + 1;
    }
    return '9240000001';
}

sub to_array {
    my ( $zTS924 ) = @_;
    return [ grep { /\A924/xms } @{ $zTS924->{_order} } ];
}

sub to_array_with_page {
    my ( $zTS924, $item_per_page, $offset ) = @_;

    require Data::Page;
    my $entries = $zTS924->to_array();
    my $page = Data::Page->new( scalar @$entries, $item_per_page, $offset );
    return ( [ $page->splice($entries) ], $page );
}

1;
__END__
