#/*
# *  Copyright 2007 hkrn <hikarin@users.sourceforge.jp>
# *
# *  Licensed under the Apache License, Version 2.0 (the "License");
# *  you may not use this file except in compliance with the License.
# *  You may obtain a copy of the License at
# *
# *      http://www.apache.org/licenses/LICENSE-2.0
# *
# *  Unless required by applicable law or agreed to in writing, software
# *  distributed under the License is distributed on an "AS IS" BASIS,
# *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# *  See the License for the specific language governing permissions and
# *  limitations under the License.
# */
#
# $Id: XCSV.pm 615 2007-05-10 14:22:45Z hikarin $
#

package Img0ch::Plugin::Upload::XCSV;

use strict;

sub new {
    my ( $iClass, $iBBS, $key, $called ) = @_;
    $called eq 'iterator' or return;

    require Img0ch::Thread;
    require Img0ch::Upload;
    my $iThread = Img0ch::Thread->new($iBBS);
    my $iUpload = Img0ch::Upload->new( $iBBS, $key );

    bless {
        __kernel => $iBBS->get_kernel(),
        __thread => $iThread,
        __upload => $iUpload,
    }, $iClass;
}

sub generate {
    my ($iApp) = @_;
    my $max = $iApp->thread()->count() + 1;

    _process( $iApp->kernel(), $iApp->upload(), $max );
    return 1;
}

*batch = \&repair;
sub repair {
    my ( $iObject, $key ) = @_;
    my $iKernel = $iObject->{__kernel};
    my $iThread = $iObject->{__thread};
    my $iUpload = $iObject->{__upload};

    $iThread->set_key($key);
    $iThread->load();
    _process( $iKernel, $iUpload, $iThread->count() );
    return 1;
}

sub _process {
    my ( $iKernel, $iUpload, $max ) = @_;
    $iUpload->count() or return 1;

    my $csv = $iUpload->path() . '/upload.csv';
    local ( *FH, $! );
    open *FH, ">${csv}"    ## no critic
        or $iKernel->throw_io_exception($csv);
    for ( my $i = 0; $i <= $max; $i++ ) {
        my $info = $iUpload->get($i);
        if ( my $ext = $info->[0] ) {
            my ( $w, $h ) = ( 0, 0 );
            $iUpload->get_thumbnail_size( $i, \$w, \$h );
            print {*FH} $i, ',', $ext, ',', $info->[1], ',', $info->[2], ',',
                $info->[3], ',', $w, ',', $h, "\n"
                or $iKernel->throw_io_exception($csv);
        }
    }
    close *FH or $iKernel->throw_io_exception($csv);

    return 1;
}

1;
__END__
