/*
 *  Copyright 2007 hkrn <hikarin@users.sourceforge.jp>
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 *
 * Zeromin.Metadata
 * $Id: metadata.js 234 2007-02-14 13:57:36Z hikarin $
 */

Zeromin.Metadata = function(bbs, metaId) {
    this.id     = metaId;
    this.bbsId  = bbs.getID();
    this.bbsDir = bbs.getBBS();
    this.cache  = null;
    this.map    = {
        "1": {
            "key": "head",
            "value": "ローカルルール"
        },
        "2": {
            "key": "meta",
            "value": "メタデータ"
        },
        "3": {
            "key": "foot",
            "value": "フッター"
        },
        "4": {
            "key": "thread_end",
            "value": "1000.txt"
        }
    };
}

Zeromin.Metadata.prototype = {
    "getID": function () { return this.id },
    "setID": function (id) {
        if ( this.id != id ) {
            this.id    = id;
            this.cache = null;
        }
    },
    "getCache": function () { return this.cache; },
    "setCache": function (cache) {
        this.cache = cache;
        return this;
    },
    "getBBS": function() { return this.bbsDir },
    "setBBS": function (id, bbs) {
        if ( this.bbsDir != bbs ) {
            this.bbsId  = id;
            this.bbsDir = bbs;
        }
        return this;
    },
    "load": function () {
        var self = this;
        Zeromin.getIO().load(
            this.toParam("load", null),
            function (storage) {
                var data = String(storage.slurp());
                var id = self.id;
                Zeromin.DOM.renderLeftMenu("leftMetaBBSLocalMenu");
                Zeromin.DOM.toggleMenu("bbs");
                Zeromin.DOM.setFunction(
                    "METADATA - " + self.map[self.id].key);
                Zeromin.DOM.statusOK(
                    self.map[id].value + "を表示しました", 1000 );
                $(document.getElementById("metadataId")).val(id);
                $(".Container", document).hide();
                switch ( id ) {
                    case 4:
                    var root = document.getElementById("threadEndRoot");
                    var res = String(data).split("<>");
                    $( "input[@name='FROM']", root ).val(res[0]);
                    $( "input[@name='mail']", root ).val(res[1]);
                    $( "input[@name='date']", root ).val(res[2]);
                    $( "textarea[@name='MESSAGE']", root ).val(
                        String(res[3]).replace( /<br>/g, "\n" ) || "" );
                    $(root).show();
                    break;
                    default:
                    $(document.getElementById("metadataContent")).val(data);
                    $(document.getElementById("metadataRoot")).show();
                    break;
                }
            },
            this
        );
    },
    "save": function (elementId) {
        var self = this;
        var root = document.getElementById(elementId || "metadataRoot");
        Zeromin.getIO().load(
            this.toParam("save", root),
            function (storage) {
                storage.writeStatus(
                    self.map[self.id].value + "を更新しました",
                    { "2": "日付の書式が正しくないため保存されませんでした" }
                );
            },
            null
        );
    },
    "toParam": function (meth, query) {
        var a   = (query != null) ? $(query).fastSerialize() : [];
        var map = this.map[this.id];
        var key = map ? map.key : '';
        a.push({ "name": "C",   "value": "bbs" });
        a.push({ "name": "M",   "value": meth });
        a.push({ "name": "bbs", "value": this.bbsId });
        a.push({ "name": "type", "value": key });
        return a;
    },
    "toString": function () { this.map[this.bbsID] }
};
