#/*
# *  Copyright 2007 hkrn <hikarin@users.sourceforge.jp>
# *
# *  Licensed under the Apache License, Version 2.0 (the "License");
# *  you may not use this file except in compliance with the License.
# *  You may obtain a copy of the License at
# *
# *      http://www.apache.org/licenses/LICENSE-2.0
# *
# *  Unless required by applicable law or agreed to in writing, software
# *  distributed under the License is distributed on an "AS IS" BASIS,
# *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# *  See the License for the specific language governing permissions and
# *  limitations under the License.
# */
#
# $Id: Upload.pm 518 2007-05-01 14:07:31Z hikarin $
#

package Zeromin::Upload;

use strict;
use base qw(Img0ch::Upload);

sub freeze {
    my ($zUpload) = @_;
    my $path = $zUpload->path();
    if ( -d $path ) {
        chmod 0700, $path;
    }
    return 1;
}

sub release {
    my ($zUpload) = @_;
    my $path = $zUpload->path();
    if ( -d $path ) {
        chmod 0755, $path;
    }
    return 1;
}

sub remove {
    my ( $zUpload, $resno ) = @_;
    my ( $bbs, $key ) = ( $zUpload->{_dir}, $zUpload->{_key} );
    my $prefix_top = "I:U:I.${bbs}.${key}";

    my $iKernel = $zUpload->{_kernel};
    if ($resno) {
        ( ref $resno || '' ) eq 'ARRAY' or $resno = [$resno];
        my $removed = 0;
        for my $i (@$resno) {
            $i = Img0ch::Kernel::intval($i);
            $zUpload->SUPER::remove($i);
            $removed++;
        }
        $zUpload->save();
        return $removed;
    }
    else {
        my $path = $zUpload->path();
        if ( -d $path ) {
            for my $uploaded_file ( @{ $zUpload->traverse() } ) {
                $zUpload->SUPER::remove($uploaded_file);
            }
            $zUpload->save();
            require File::Path;
            File::Path::rmtree($path)
                or $iKernel->throw_io_exception($path);
            return 1;
        }
        else {
            return 0;
        }
    }

    return 1;
}

sub repair {
    my ($zUpload) = @_;
    my $iKernel = $zUpload->{_kernel};

    require File::Basename;
    my $path = $zUpload->path();
    -d $path or return 0;

    my $iRepos = $zUpload->{_rs};
    my ( $bbs, $key ) = ( $zUpload->{_dir}, $zUpload->{_key} );
    my $prefix_top = "I:U:I.${bbs}.${key}";
    foreach my $file ( @{ $zUpload->traverse() } ) {
        next if $file =~ /\.cgi\z/xms or $file =~ /\.s?pch\z/xms;
        if ($file =~ m{/(\d+)\.(\w+)\z}xms) {
            my $resno     = $1 || next;
            my $extension = $2 || next;
            my ( $width, $height ) = $zUpload->get_dimensions($file);
            my $hash = $zUpload->get_digest($file);
            my $prefix = join '.', $prefix_top, $resno;
            $iRepos->set( "${prefix}.extension", $extension );
            $iRepos->set( "${prefix}.width",     $width );
            $iRepos->set( "${prefix}.height",    $height );
            $iRepos->set( "${prefix}.hash",      $hash );
        }
        elsif ( $file =~ m{/t(\d+)\.\w+\z}xms) {
            my $resno     = $1 || next;
            my ( $width, $height ) = $zUpload->get_dimensions($file);
            $zUpload->set_thumbnail_size( $resno, $width, $height );
        }
    }

    $iRepos->save();
    return 1;
}

1;
__END__
