#/*
# *  Copyright 2007 hkrn <hikarin@users.sourceforge.jp>
# *
# *  Licensed under the Apache License, Version 2.0 (the "License");
# *  you may not use this file except in compliance with the License.
# *  You may obtain a copy of the License at
# *
# *      http://www.apache.org/licenses/LICENSE-2.0
# *
# *  Unless required by applicable law or agreed to in writing, software
# *  distributed under the License is distributed on an "AS IS" BASIS,
# *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# *  See the License for the specific language governing permissions and
# *  limitations under the License.
# */
#
# $Id: XCSV.pm 517 2007-05-01 14:06:57Z hikarin $
#

package Img0ch::Plugin::Upload::XCSV;

use strict;

sub generate {
    my ($iApp)  = @_;
    my $iKernel = $iApp->kernel();
    my $iUpload = $iApp->upload();

    local ( *FH, $! );
    my $csv = $iUpload->path() . '/upload.csv';
    open *FH, ">${csv}" ## no critic
        or $iKernel->throw_io_exception($csv);
    my $resno = $iApp->thread()->count() + 1;
    for ( my $i = 0; $i <= $resno; $i++ ) {
        my $info = $iUpload->get($i);
        if ( my $ext = $info->[0] ) {
            my ( $w, $h ) = ( 0, 0 );
            $iUpload->get_thumbnail_size( $i, \$w, \$h );
            print {*FH} $i, ',', $ext, ',', $info->[1], ',', $info->[2],
                ',', $info->[3], ',', $w, ',', $h, "\n"
                or $iKernel->throw_io_exception($csv);
        }
    }
    close *FH or $iKernel->throw_io_exception($csv);

    return 1;
}

1;
__END__
