#/*
# *  Copyright 2007 hkrn <hikarin@users.sourceforge.jp>
# *
# *  Licensed under the Apache License, Version 2.0 (the "License");
# *  you may not use this file except in compliance with the License.
# *  You may obtain a copy of the License at
# *
# *      http://www.apache.org/licenses/LICENSE-2.0
# *
# *  Unless required by applicable law or agreed to in writing, software
# *  distributed under the License is distributed on an "AS IS" BASIS,
# *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# *  See the License for the specific language governing permissions and
# *  limitations under the License.
# */
#
# $Id: NicoVideo.pm 363 2007-03-16 15:11:10Z hikarin $
#

package Img0ch::Plugin::Rewrite::StreamService::NicoVideo;

use strict;

sub new {
    my ( $iClass, $iBBS ) = @_;
    my $iConfig = $iBBS->get_kernel()->get_config();

    bless [
        ( $iConfig->get_int('nicovideo.width')  || 320 ),
        ( $iConfig->get_int('nicovideo.height') || 216 ),
    ], $iClass;
}

sub from_bbs {
    my ( $iObject, $key, $count, $resno, $text ) = @_;
    my ( $width, $height ) = ( $iObject->[0], $iObject->[1] );

    $$text =~ s{
        (?:\<a[^>]+>)?
        http://w?w?w?\.?nicovideo\.jp/watch\?v=(\w+)
        (?:\</a>)?
        }
        {<iframe src="http://www.nicovideo.jp/thumb?v=$1"
  width="${width}" height="${height}" frameborder="0" scrolling="no">
</iframe><br />}gxms;
    return;
}

*from_read = \&from_bbs;

1;
__END__
