#/*
# *  Copyright 2007 hkrn <hikarin@users.sourceforge.jp>
# *
# *  Licensed under the Apache License, Version 2.0 (the "License");
# *  you may not use this file except in compliance with the License.
# *  You may obtain a copy of the License at
# *
# *      http://www.apache.org/licenses/LICENSE-2.0
# *
# *  Unless required by applicable law or agreed to in writing, software
# *  distributed under the License is distributed on an "AS IS" BASIS,
# *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# *  See the License for the specific language governing permissions and
# *  limitations under the License.
# */
#
# $Id: Watchme.pm 363 2007-03-16 15:11:10Z hikarin $
#

package Img0ch::Plugin::Rewrite::StreamService::Watchme;

use strict;

sub new {
    my ( $iClass, $iBBS ) = @_;
    my $iConfig = $iBBS->get_kernel()->get_config();

    bless [
        ( $iConfig->get_int('watchme.width')  || 339 ),
        ( $iConfig->get_int('watchme.height') || 300 ),
    ], $iClass;
}

sub from_bbs {
    my ( $iObject, $key, $count, $resno, $text ) = @_;
    my ( $width, $height ) = ( $iObject->[0], $iObject->[1] );

    $$text =~ s{
        (?:\<a[^>]+>)?
        http://w?w?w?\.?watchme\.tv/v/\?mid=(\w+)
        (?:\</a>)?
        }
        {<object width="${width}" height="${height}">
<param name="movie" value="http://www.watchme.tv/p/video_output.swf?mid=$1" />
<embed src="http://www.watchme.tv/p/video_output.swf?mid=$1"
  type="application/x-shockwave-flash" width="${width}" height="${height}" />
</object><br />}gxms;
    return;
}

*from_read = \&from_bbs;

1;
__END__
