/*
 *  Copyright 2007 hkrn <hikarin@users.sourceforge.jp>
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 *
 * Img0ch.App
 * $Id: app.js 355 2007-03-16 13:29:40Z hikarin $
 *
 * @require jquery.js
 */

var Img0ch;
if ( typeof Img0ch == "undefined" ) Img0ch = {};

Img0ch.App = (function() {
    var bbs_, bbsURI_, cgiURI_, rendererURI_, staticURI_;
    var isEnabledRedirectRenderer_ = false;
    var rendererPath_ = "read.html";
    var rendererSeparator_ = "#";
    var rewritten_ = {};
    return {
    "disableRedirectRenderer": function() {
        isEnabledRedirectRenderer_ = false;
        return;
    },
    "enableRedirectRenderer": function() {
        isEnabledRedirectRenderer_ = true;
        return;
    },
    "getBBS": function() { return bbs_ },
    "getBBSURI": function() { return bbsURI_ },
    "getCGIURI": function() { return cgiURI_ },
    "getRendererURI": function() { return rendererURI_ },
    "getStaticURI": function() { return staticURI_ },
    "initForm": function( cookiePath, formClass ) {
        if ( !formClass ) formClass = "form.comment";
        jQuery(function () {
            jQuery("//input[@name='FROM']").val(
                jQuery.cookie("img0ch_name") || "");
            jQuery("//input[@name='mail']").val(
                jQuery.cookie("img0ch_mail") || "");
            jQuery(formClass).submit(function () {
                if ( !jQuery("textarea[@name='MESSAGE']",
                    this).val() && jQuery("input[@type='submit']",
                    this).val() == "書き込む" ) {
                    if ( confirm(
                        "本文がありません。それでも投稿しますか？") == false ) {
                        return false;
                    }
                }
                var option = { "expires": 30,
                    "path": cookiePath };
                jQuery.cookie( "img0ch_name", jQuery(
                    "input[@name='FROM']", this ).val(), option );
                jQuery.cookie( "img0ch_mail", jQuery(
                    "input[@name='mail']", this ).val(), option );
                jQuery("//input[@type='submit']").attr({ "disabled": true });
                return true;
            });
        });
    },
    "redirectRenderer": function( linkElement, query ) {
        var linkTo  = linkElement.href;
        var content = linkElement.innerHTML;
        if ( isEnabledRedirectRenderer_
            && !rewritten_[content + linkTo] ) {
            var qstring = "";
            if ( query ) {
                var qarray  = [];
                for ( var i in query ) {
                    qarray.push(encodeURIComponent(i)
                        + '=' + encodeURIComponent(query[i]));
                }
                qstring += '?' + qarray.join('&');
            }
            linkTo.match(/(.+)\/test\/read\.cgi\/(.+)/);
            var rewrittenURI = RegExp.$1 + "/test/"
                + rendererPath_ + qstring
                + rendererSeparator_ + RegExp.$2;
            linkElement.href = rewrittenURI;
            rewritten_[content + rewrittenURI] = true;
        }
        return true;
    },
    "removeFile": function() {
        if (!this.UFM) {
            jQuery.ajax({
                "async": false,
                "dataType": "script",
                "url": staticURI_ + "/js/img0ch/app/ufm.js" });
        }
        var a = arguments;
        this.UFM.removeFile( a[0], a[1], a[2] );
        return false;
    },
    "setBBS": function(bbs) {
        bbs_ = bbs;
        return;
    },
    "setBBSURI": function(bbsURI) {
        bbsURI_ = bbsURI;
        return;
    },
    "setCGIURI": function(cgiURI) {
        cgiURI_ = cgiURI;
        return;
    },
    "setRendererURI": function(rendererURI) {
        rendererURI_ = rendererURI;
        return;
    },
    "setRenderer": function( path, separator ) {
        rendererPath_ = path;
        rendererSeparator_ = separator;
        return;
    },
    "setStaticURI": function(staticURI) {
        staticURI_ = staticURI;
        return;
    }
    };
})();
