#/*
# *  Copyright 2007 hkrn <hikarin@users.sourceforge.jp>
# *
# *  Licensed under the Apache License, Version 2.0 (the "License");
# *  you may not use this file except in compliance with the License.
# *  You may obtain a copy of the License at
# *
# *      http://www.apache.org/licenses/LICENSE-2.0
# *
# *  Unless required by applicable law or agreed to in writing, software
# *  distributed under the License is distributed on an "AS IS" BASIS,
# *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# *  See the License for the specific language governing permissions and
# *  limitations under the License.
# */
#
# $Id: category.pm 390 2007-03-20 14:06:06Z hikarin $
#

package Zeromin2::App::category;

use strict;
use Zeromin::Category qw();

sub load {
    my ($zApp) = @_;
    $zApp->privilege() or return $zApp->return_value( 1, [] );

    my $zCat = Zeromin::Category->new( $zApp->kernel() );
    $zCat->load();
    return $zApp->return_value( 0,
        $zCat->all_with_page( $zApp->page_param() ) );
}

sub save {
    my ($zApp) = @_;
    $zApp->check_csrf() or return $zApp->return_value(1);
    $zApp->privilege('can_edit_category')
        or $zApp->privilege('can_add_category')
        or return $zApp->return_value(1);

    my $iRequest = $zApp->request();
    my $id       = $iRequest->param_int('id');
    my $name     = $iRequest->param('name');
    my $zCat     = Zeromin::Category->new( $zApp->kernel() );
    $zCat->load();

    if ( $name eq '' ) {
        $zApp->logger( 0, 'NO CATEGORY NAME WAS SET' );
        return $zApp->return_value(2);
    }
    elsif ( $name =~ /\A\d*\z/xms ) {
        $zApp->logger( 0, 'CANNNOT SET NUMBER-ONLY NAME' );
        return $zApp->return_value(3);
    }
    elsif ( $zCat->is_duplicated($name) ) {
        $zApp->logger( 0, 'DUPLICATED NAME: %s', [$name] );
        return $zApp->return_value(4);
    }
    elsif ( $zCat->exist($id) ) {
        $zApp->privilege('can_edit_category')
            or return $zApp->return_value(1);
        my $cat = $zCat->get($id);
        $zCat->set( $id, $name );
        $zCat->save();
        $zApp->logger( 1, 'EDIT CATEGORY: %s to %s',
            [ $cat->{name}, $name ] );
        $zApp->add_template_param( { Done_category_edit => 1 } );
        return $zApp->return_value(0);
    }
    else {
        $zApp->privilege('can_add_category')
            or return $zApp->return_value(1);
        $zCat->add($name);
        $zCat->save();
        $zApp->logger( 1, 'CREATE CATEGORY: %s', [$name] );
        $zApp->add_template_param( { Done_category_create => 1 } );
        return $zApp->return_value( 0, $zCat->get_id($name) );
    }
}

sub create {
    my ($zApp) = @_;
    $zApp->privilege('can_add_category') or return $zApp->return_value(1);
    return $zApp->return_value(0);
}

sub edit {
    my ($zApp) = @_;
    $zApp->privilege('can_edit_category') or return $zApp->return_value(1);

    my $zCat = Zeromin::Category->new( $zApp->kernel() );
    my $id   = $zApp->request()->param('id');
    $zCat->load();
    $zApp->add_template_param( { Id => $id, Name => $zCat->get_name($id) } );
    return $zApp->return_value(0);
}

sub remove {
    my ($zApp) = @_;
    $zApp->check_csrf()                     or return $zApp->return_value(1);
    $zApp->privilege('can_remove_category') or return $zApp->return_value(1);

    my $status = {};
    my $zCat   = Zeromin::Category->new( $zApp->kernel() );
    $zCat->load();

    my $iRequest = $zApp->request();
    my @ids      = $iRequest->param('id');
    for my $id (@ids) {
        $id = Img0ch::Kernel::intval($id);
        $id > 1 or next;
        my $name = $zCat->get_name($id);
        if ( $zCat->remove($id) ) {
            $zCat->save();
            $zApp->logger( 1, 'REMOVE CATEGORY: %s', [$name] );
            $status->{$id} = 1;
        }
        else {
            $zApp->logger( 0, 'TRIED REMOVING INEXIST CATEGORY: %s',
                [$name] );
            $status->{$id} = 0;
        }
    }
    $zCat->save();

    return $zApp->return_value( 0, $status );
}

1;
__END__
