#/*
# *  Copyright 2007 hkrn <hikarin@users.sourceforge.jp>
# *
# *  Licensed under the Apache License, Version 2.0 (the "License");
# *  you may not use this file except in compliance with the License.
# *  You may obtain a copy of the License at
# *
# *      http://www.apache.org/licenses/LICENSE-2.0
# *
# *  Unless required by applicable law or agreed to in writing, software
# *  distributed under the License is distributed on an "AS IS" BASIS,
# *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# *  See the License for the specific language governing permissions and
# *  limitations under the License.
# */
#
# $Id: Thread.pm 363 2007-03-16 15:11:10Z hikarin $
#

package Zeromin::Log::Thread;

use strict;
use base qw(Img0ch::Filter::Thread);

sub new {
    my ( $iClass, $iBBS ) = @_;
    my $repos_path = $iBBS->get_repos_path('log');

    bless {
        __bbs => ( $iBBS->get_name() || 'test' ),
        __rs => $iBBS->get_kernel()->get_repos($repos_path),
    }, $iClass;
}

sub load {1}

sub all {
    my ($zLogThr) = @_;
    my $ip_table = {};
    $zLogThr->{__rs}->iterate(
        sub {
            my ( $key, $value, $ip_table, $bbs ) = @_;
            if ( $key =~ /\AI:F:T\.$bbs\.(\d+)\.(\w+)/xms ) {
                $ip_table->{$1} ||= {};
                $ip_table->{$1}->{$2} = $$value;
            }
            return 0;
        },
        $ip_table,
        $zLogThr->{__bbs}
    );

    my $ret = [];
    while ( my ( $ip_group, $hash ) = each %{$ip_table} ) {
        push @$ret,
            {
            atime    => $hash->{time},
            ip       => $hash->{ip},
            ip_group => $ip_group,
            };
    }
    return $ret;
}

sub all_with_page {
    my ( $zLogThr, $item_per_page, $offset ) = @_;

    require Data::Page;
    my $entries = $zLogThr->all();
    my $page = Data::Page->new( scalar @$entries, $item_per_page, $offset );
    return ( [ $page->splice($entries) ], $page );
}

1;
__END__
