/*
 *  Copyright 2007 hkrn <hikarin@users.sourceforge.jp>
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 *
 * Zeromin.Setting
 * $Id: setting.js 208 2007-02-10 12:50:14Z hikarin $
 */

Zeromin.Setting = function(bbs) {
    this.bbsID     = bbs.getID();
    this.bbsDir    = bbs.getBBS();
    this.cache  = null;
    this.render = "div#settingMain";
    this.color  = {
        "BBS_BG_COLOR":         "background-color",
        "BBS_TEXT_COLOR":       "color",
        "BBS_MENU_COLOR":       "background-color",
        "BBS_NAME_COLOR":       "color",
        "BBS_MAKETHREAD_COLOR": "background-color",
        "BBS_LINK_COLOR":       "color",
        "BBS_THREAD_COLOR":     "background-color",
        "BBS_ALINK_COLOR":      "color",
        "BBS_TITLE_COLOR":      "color",
        "BBS_VLINK_COLOR":      "color",
        "BBS_SUBJECT_COLOR":    "color"
    };
}

Zeromin.Setting.prototype = {
    "getID": function () { this.bbsID },
    "getBBS": function () { this.bbsDir },
    "getCache": function () { return this.cache; },
    "setCache": function (cache) {
        this.cache = cache;
        return this;
    },
    "setBBS": function (id, bbs) {
        if ( this.bbsDir != bbs ) {
            this.bbsID    = id;
            this.bbsDir   = bbs;
            this.cache = null;
        }
        return this;
    },
    "load": function (renderType) {
        var self    = this;
        var map     = { "main":     "div#settingMain",
                        "color":    "div#settingColor",
                        "restrict": "div#settingRestrict",
                        "other":    "div#settingOther",
                        "upload":   "div#settingUpload" };
        var render  = map[renderType] || "div#settingMain";
        this.render = render;
        Zeromin.getIO().load(
            this.toParam("load"),
            function (storage) {
                var data = storage.slurp() || {};
                var root = document.getElementById("settingRoot");
                $(render).find("input,textarea").each(function () {
                    var i = data[this.name];
                    if ( !i ) return;
                    var type = this.type;
                    if ( type == "checkbox" ) {
                        $(this).attr({
                            "checked":  ( i.value ? true : false ),
                            "disabled": ( i.privilege ? false : true )
                        });
                    }
                    else if ( type == "radio" ) {
                        $(this).attr({
                            "checked":
                                ( this.value == i.value ? true : false ),
                            "disabled": ( i.privilege ? false : true )
                        });
                    }
                    else {
                        var val = i.value;
                        if ( this.tagName.toLowerCase() == "textarea" ) {
                            val = val.replace(/,+/g, "\n");
                        }
                        if ( i.type == "integer" ) {
                            val = Zeromin.intval(val);
                        }
                        $(this).val(String(val)).attr({
                            "disabled": ( i.privilege ? false : true )
                        });
                    }
                });
                $(document.getElementById("settingColor")).find("input").each(
                    function() {
                        self.updateColorPreview(this.name, this.value);
                    }
                );
                Zeromin.DOM.toggleMenu("bbs");
                Zeromin.DOM.renderLeftMenu("leftSettingMenu");
                Zeromin.DOM.setFunction(
                    "SETTING - " + Zeromin.getBBS().getName()
                );
                $("div.Container", document).hide();
                $("div.Setting", root).hide();
                $(render, root).show().parent().show();
                Zeromin.DOM.statusOK("掲示板設定を表示しました", 1000);
            },
            this
        );
        $(document.getElementById("settingColor")).click();
    },
    "save": function(place) {
        var self  = this;
        var param = this.toParam("save", place);
        Zeromin.getIO().load(
            param,
            function (storage) {
                if ( storage.isReturnedSuccess() ) {
                    self.setCache(null);
                }
                storage.writeStatus("掲示板設定を保存しました", {});
            },
            null
        );
    },
    "updateColorPreview": function(key, val) {
        var classTarget = ".preview_of_" + key;
        var cssTarget   = this.color[key] || "color";
        $(classTarget,
            document.getElementById("settingColor")
            ).css(cssTarget, val);
    },
    "render": function() {},
    "toParam": function (meth, query) {
        var a;
        if (query != null) {
            var q = $(query);
            a = q.fastSerialize();
            q.find("input,textarea").each(function(){
                var name = this.name;
                if ( !name ) return;
                a.push({ "name": "key", "value": name });
            });
        }
        else {
            a = [];
        }
        a.push({ "name": "C",    "value": "bbs"     });
        a.push({ "name": "M",    "value": meth      });
        a.push({ "name": "type", "value": "setting" });
        a.push({ "name": "bbs",  "value": this.bbsID   });
        return a;
    },
    "toString": function() { return this.getBBS() }
};
